/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

class QualifierDefinitionTests {
    @Mock
    private ConfigurableListableBeanFactory beanFactory;
    @Captor
    private ArgumentCaptor<DependencyDescriptor> descriptorCaptor;

    QualifierDefinitionTests() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    void forElementFieldIsNullShouldReturnNull() {
        Assertions.assertThat((Object)QualifierDefinition.forElement((AnnotatedElement)null)).isNull();
    }

    @Test
    void forElementWhenElementIsNotFieldShouldReturnNull() {
        Assertions.assertThat((Object)QualifierDefinition.forElement(this.getClass())).isNull();
    }

    @Test
    void forElementWhenElementIsFieldWithNoQualifiersShouldReturnNull() {
        QualifierDefinition definition = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigA.class, (String)"noQualifier"));
        Assertions.assertThat((Object)definition).isNull();
    }

    @Test
    void forElementWhenElementIsFieldWithQualifierShouldReturnDefinition() {
        QualifierDefinition definition = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigA.class, (String)"directQualifier"));
        Assertions.assertThat((Object)definition).isNotNull();
    }

    @Test
    void matchesShouldCallBeanFactory() {
        Field field = ReflectionUtils.findField(ConfigA.class, (String)"directQualifier");
        QualifierDefinition qualifierDefinition = QualifierDefinition.forElement((AnnotatedElement)field);
        qualifierDefinition.matches(this.beanFactory, "bean");
        ((ConfigurableListableBeanFactory)Mockito.verify((Object)this.beanFactory)).isAutowireCandidate((String)ArgumentMatchers.eq((Object)"bean"), (DependencyDescriptor)this.descriptorCaptor.capture());
        Assertions.assertThat((Object)((DependencyDescriptor)this.descriptorCaptor.getValue()).getAnnotatedElement()).isEqualTo((Object)field);
    }

    @Test
    void applyToShouldSetQualifierElement() {
        Field field = ReflectionUtils.findField(ConfigA.class, (String)"directQualifier");
        QualifierDefinition qualifierDefinition = QualifierDefinition.forElement((AnnotatedElement)field);
        RootBeanDefinition definition = new RootBeanDefinition();
        qualifierDefinition.applyTo(definition);
        Assertions.assertThat((Object)definition.getQualifiedElement()).isEqualTo((Object)field);
    }

    @Test
    void hashCodeAndEqualsShouldWorkOnDifferentClasses() {
        QualifierDefinition directQualifier1 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigA.class, (String)"directQualifier"));
        QualifierDefinition directQualifier2 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigB.class, (String)"directQualifier"));
        QualifierDefinition differentDirectQualifier1 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigA.class, (String)"differentDirectQualifier"));
        QualifierDefinition differentDirectQualifier2 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigB.class, (String)"differentDirectQualifier"));
        QualifierDefinition customQualifier1 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigA.class, (String)"customQualifier"));
        QualifierDefinition customQualifier2 = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(ConfigB.class, (String)"customQualifier"));
        Assertions.assertThat((int)directQualifier1.hashCode()).isEqualTo(directQualifier2.hashCode());
        Assertions.assertThat((int)differentDirectQualifier1.hashCode()).isEqualTo(differentDirectQualifier2.hashCode());
        Assertions.assertThat((int)customQualifier1.hashCode()).isEqualTo(customQualifier2.hashCode());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)differentDirectQualifier1).isEqualTo((Object)differentDirectQualifier1)).isEqualTo((Object)differentDirectQualifier2)).isNotEqualTo((Object)directQualifier2);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)directQualifier1).isEqualTo((Object)directQualifier1)).isEqualTo((Object)directQualifier2)).isNotEqualTo((Object)differentDirectQualifier1);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)customQualifier1).isEqualTo((Object)customQualifier1)).isEqualTo((Object)customQualifier2)).isNotEqualTo((Object)differentDirectQualifier1);
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CustomQualifier {
    }

    static class ConfigB {
        @MockBean
        @Qualifier(value="test")
        private Object directQualifier;
        @MockBean
        @Qualifier(value="different")
        private Object differentDirectQualifier;
        @MockBean
        @CustomQualifier
        private Object customQualifier;

        ConfigB() {
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ConfigA {
        @MockBean
        private Object noQualifier;
        @MockBean
        @Qualifier(value="test")
        private Object directQualifier;
        @MockBean
        @Qualifier(value="different")
        private Object differentDirectQualifier;
        @MockBean
        @CustomQualifier
        private Object customQualifier;

        ConfigA() {
        }
    }
}

