/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.BDDMockito;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@TestMethodOrder(value=MethodOrderer.Alphanumeric.class)
class ResetMocksTestExecutionListenerTests {
    @Autowired
    private ApplicationContext context;

    ResetMocksTestExecutionListenerTests() {
    }

    @Test
    void test001() {
        BDDMockito.given((Object)this.getMock("none").greeting()).willReturn((Object)"none");
        BDDMockito.given((Object)this.getMock("before").greeting()).willReturn((Object)"before");
        BDDMockito.given((Object)this.getMock("after").greeting()).willReturn((Object)"after");
    }

    @Test
    void test002() {
        Assertions.assertThat((String)this.getMock("none").greeting()).isEqualTo("none");
        Assertions.assertThat((String)this.getMock("before").greeting()).isNull();
        Assertions.assertThat((String)this.getMock("after").greeting()).isNull();
    }

    ExampleService getMock(String name) {
        return (ExampleService)this.context.getBean(name, ExampleService.class);
    }

    static class BrokenFactoryBean
    implements FactoryBean<String> {
        BrokenFactoryBean() {
        }

        public String getObject() {
            throw new IllegalStateException();
        }

        public Class<?> getObjectType() {
            return String.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        ExampleService before(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.before());
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        ExampleService after(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.after());
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        ExampleService none(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class);
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        @Lazy
        ExampleService fail() {
            throw new RuntimeException();
        }

        @Bean
        BrokenFactoryBean brokenFactoryBean() {
            return new BrokenFactoryBean();
        }
    }
}

