/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleStringGenericService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
class SpyBeanWithNameOnTestFieldForMultipleExistingBeansTests {
    @SpyBean(name="two")
    private SimpleExampleStringGenericService spy;

    SpyBeanWithNameOnTestFieldForMultipleExistingBeansTests() {
    }

    @Test
    void testSpying() {
        MockingDetails mockingDetails = Mockito.mockingDetails((Object)this.spy);
        Assertions.assertThat((boolean)mockingDetails.isSpy()).isTrue();
        Assertions.assertThat((String)mockingDetails.getMockCreationSettings().getMockName().toString()).isEqualTo("two");
    }

    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config() {
        }

        @Bean
        SimpleExampleStringGenericService one() {
            return new SimpleExampleStringGenericService("one");
        }

        @Bean
        SimpleExampleStringGenericService two() {
            return new SimpleExampleStringGenericService("two");
        }
    }
}

