/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.system;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.Extensions;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.boot.test.system.OutputCaptureExtension;

@Extensions(value={@ExtendWith(value={OutputCaptureExtension.class}), @ExtendWith(value={BeforeAllExtension.class})})
class OutputExtensionExtendWithTests {
    OutputExtensionExtendWithTests() {
    }

    @Test
    void captureShouldReturnOutputCapturedBeforeTestMethod(CapturedOutput output) {
        Assertions.assertThat((CharSequence)output).contains(new CharSequence[]{"Before all"}).doesNotContain(new CharSequence[]{"Hello"});
    }

    @Test
    void captureShouldReturnAllCapturedOutput(CapturedOutput output) {
        System.out.println("Hello World");
        System.err.println("Error!!!");
        Assertions.assertThat((CharSequence)output).contains(new CharSequence[]{"Before all"}).contains(new CharSequence[]{"Hello World"}).contains(new CharSequence[]{"Error!!!"});
    }

    static class BeforeAllExtension
    implements BeforeAllCallback {
        BeforeAllExtension() {
        }

        public void beforeAll(ExtensionContext context) {
            System.out.println("Before all");
        }
    }
}

