/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;

class TestPropertyValuesTests {
    private final ConfigurableEnvironment environment = new StandardEnvironment();

    TestPropertyValuesTests() {
    }

    @Test
    void applyToEnvironmentShouldAttachConfigurationPropertySource() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz"}).applyTo(this.environment);
        PropertySource source = this.environment.getPropertySources().get("configurationProperties");
        Assertions.assertThat((Object)source).isNotNull();
    }

    @Test
    void applyToDefaultPropertySource() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz", "hello.world=hi"}).applyTo(this.environment);
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("baz");
        Assertions.assertThat((String)this.environment.getProperty("hello.world")).isEqualTo("hi");
    }

    @Test
    void applyToSystemPropertySource() {
        TestPropertyValues.of((String[])new String[]{"FOO_BAR=BAZ"}).applyTo(this.environment, TestPropertyValues.Type.SYSTEM_ENVIRONMENT);
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("BAZ");
        Assertions.assertThat((boolean)this.environment.getPropertySources().contains("test-systemEnvironment")).isTrue();
    }

    @Test
    void applyToWithSpecificName() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz"}).applyTo(this.environment, TestPropertyValues.Type.MAP, "other");
        Assertions.assertThat((Object)this.environment.getPropertySources().get("other")).isNotNull();
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("baz");
    }

    @Test
    void applyToExistingNameAndDifferentTypeShouldOverrideExistingOne() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz", "hello.world=hi"}).applyTo(this.environment, TestPropertyValues.Type.MAP, "other");
        TestPropertyValues.of((String[])new String[]{"FOO_BAR=BAZ"}).applyTo(this.environment, TestPropertyValues.Type.SYSTEM_ENVIRONMENT, "other");
        Assertions.assertThat((Object)this.environment.getPropertySources().get("other")).isInstanceOf(SystemEnvironmentPropertySource.class);
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("BAZ");
        Assertions.assertThat((String)this.environment.getProperty("hello.world")).isNull();
    }

    @Test
    void applyToExistingNameAndSameTypeShouldMerge() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz", "hello.world=hi"}).applyTo(this.environment, TestPropertyValues.Type.MAP);
        TestPropertyValues.of((String[])new String[]{"foo.bar=new"}).applyTo(this.environment, TestPropertyValues.Type.MAP);
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("new");
        Assertions.assertThat((String)this.environment.getProperty("hello.world")).isEqualTo("hi");
    }

    @Test
    void andShouldChainAndAddSingleKeyValue() {
        TestPropertyValues.of((String[])new String[]{"foo.bar=baz"}).and(new String[]{"hello.world=hi"}).and(new String[]{"bling.blah=bing"}).applyTo(this.environment, TestPropertyValues.Type.MAP);
        Assertions.assertThat((String)this.environment.getProperty("foo.bar")).isEqualTo("baz");
        Assertions.assertThat((String)this.environment.getProperty("hello.world")).isEqualTo("hi");
        Assertions.assertThat((String)this.environment.getProperty("bling.blah")).isEqualTo("bing");
    }

    @Test
    void applyToSystemPropertiesShouldSetSystemProperties() {
        TestPropertyValues.of((String[])new String[]{"foo=bar"}).applyToSystemProperties(() -> {
            Assertions.assertThat((String)System.getProperty("foo")).isEqualTo("bar");
            return null;
        });
    }

    @Test
    void applyToSystemPropertiesShouldRestoreSystemProperties() {
        System.setProperty("foo", "bar1");
        System.clearProperty("baz");
        try {
            TestPropertyValues.of((String[])new String[]{"foo=bar2", "baz=bing"}).applyToSystemProperties(() -> {
                Assertions.assertThat((String)System.getProperty("foo")).isEqualTo("bar2");
                Assertions.assertThat((String)System.getProperty("baz")).isEqualTo("bing");
                return null;
            });
            Assertions.assertThat((String)System.getProperty("foo")).isEqualTo("bar1");
            Assertions.assertThat((Map)System.getProperties()).doesNotContainKey((Object)"baz");
        }
        finally {
            System.clearProperty("foo");
        }
    }

    @Test
    void applyToSystemPropertiesWhenValueIsNullShouldRemoveProperty() {
        System.setProperty("foo", "bar1");
        try {
            TestPropertyValues.of((String[])new String[]{"foo"}).applyToSystemProperties(() -> {
                Assertions.assertThat((Map)System.getProperties()).doesNotContainKey((Object)"foo");
                return null;
            });
            Assertions.assertThat((String)System.getProperty("foo")).isEqualTo("bar1");
        }
        finally {
            System.clearProperty("foo");
        }
    }
}

