/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.net.URI;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.web.util.UriTemplateHandler;

class LocalHostUriTemplateHandlerTests {
    LocalHostUriTemplateHandlerTests() {
    }

    @Test
    void createWhenEnvironmentIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler(null)).withMessageContaining("Environment must not be null");
    }

    @Test
    void createWhenSchemeIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler((Environment)new MockEnvironment(), null)).withMessageContaining("Scheme must not be null");
    }

    @Test
    void createWhenHandlerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler((Environment)new MockEnvironment(), "http", null)).withMessageContaining("Handler must not be null");
    }

    @Test
    void getRootUriShouldUseLocalServerPort() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("local.server.port", "1234");
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo("http://localhost:1234");
    }

    @Test
    void getRootUriWhenLocalServerPortMissingShouldUsePort8080() {
        MockEnvironment environment = new MockEnvironment();
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo("http://localhost:8080");
    }

    @Test
    void getRootUriUsesCustomScheme() {
        MockEnvironment environment = new MockEnvironment();
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment, "https");
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo("https://localhost:8080");
    }

    @Test
    void getRootUriShouldUseContextPath() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("server.servlet.context-path", "/foo");
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo("http://localhost:8080/foo");
    }

    @Test
    void expandShouldUseCustomHandler() {
        MockEnvironment environment = new MockEnvironment();
        UriTemplateHandler uriTemplateHandler = (UriTemplateHandler)Mockito.mock(UriTemplateHandler.class);
        HashMap uriVariables = new HashMap();
        URI uri = URI.create("https://www.example.com");
        BDDMockito.given((Object)uriTemplateHandler.expand("https://localhost:8080/", uriVariables)).willReturn((Object)uri);
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment, "https", uriTemplateHandler);
        Assertions.assertThat((URI)handler.expand("/", uriVariables)).isEqualTo((Object)uri);
        ((UriTemplateHandler)Mockito.verify((Object)uriTemplateHandler)).expand("https://localhost:8080/", uriVariables);
    }
}

