/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.web.client.MockServerRestTemplateCustomizer;
import org.springframework.boot.test.web.client.RootUriRequestExpectationManager;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.SimpleRequestExpectationManager;
import org.springframework.test.web.client.UnorderedRequestExpectationManager;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.web.client.RestTemplate;

class MockServerRestTemplateCustomizerTests {
    private MockServerRestTemplateCustomizer customizer;

    MockServerRestTemplateCustomizerTests() {
    }

    @BeforeEach
    void setup() {
        this.customizer = new MockServerRestTemplateCustomizer();
    }

    @Test
    void createShouldUseSimpleRequestExpectationManager() {
        MockServerRestTemplateCustomizer customizer = new MockServerRestTemplateCustomizer();
        customizer.customize(new RestTemplate());
        Assertions.assertThat((Object)customizer.getServer()).extracting("expectationManager").isInstanceOf(SimpleRequestExpectationManager.class);
    }

    @Test
    void createWhenExpectationManagerClassIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new MockServerRestTemplateCustomizer(null)).withMessageContaining("ExpectationManager must not be null");
    }

    @Test
    void createShouldUseExpectationManagerClass() {
        MockServerRestTemplateCustomizer customizer = new MockServerRestTemplateCustomizer(UnorderedRequestExpectationManager.class);
        customizer.customize(new RestTemplate());
        Assertions.assertThat((Object)customizer.getServer()).extracting("expectationManager").isInstanceOf(UnorderedRequestExpectationManager.class);
    }

    @Test
    void detectRootUriShouldDefaultToTrue() {
        MockServerRestTemplateCustomizer customizer = new MockServerRestTemplateCustomizer(UnorderedRequestExpectationManager.class);
        customizer.customize(new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("https://example.com").build());
        Assertions.assertThat((Object)customizer.getServer()).extracting("expectationManager").isInstanceOf(RootUriRequestExpectationManager.class);
    }

    @Test
    void setDetectRootUriShouldDisableRootUriDetection() {
        this.customizer.setDetectRootUri(false);
        this.customizer.customize(new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("https://example.com").build());
        Assertions.assertThat((Object)this.customizer.getServer()).extracting("expectationManager").isInstanceOf(SimpleRequestExpectationManager.class);
    }

    @Test
    void customizeShouldBindServer() {
        RestTemplate template = new RestTemplateBuilder(new RestTemplateCustomizer[]{this.customizer}).build();
        this.customizer.getServer().expect(MockRestRequestMatchers.requestTo((String)"/test")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess());
        template.getForEntity("/test", String.class, new Object[0]);
        this.customizer.getServer().verify();
    }

    @Test
    void getServerWhenNoServersAreBoundShouldThrowException() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((MockServerRestTemplateCustomizer)this.customizer).getServer()).withMessageContaining("Unable to return a single MockRestServiceServer since MockServerRestTemplateCustomizer has not been bound to a RestTemplate");
    }

    @Test
    void getServerWhenMultipleServersAreBoundShouldThrowException() {
        this.customizer.customize(new RestTemplate());
        this.customizer.customize(new RestTemplate());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((MockServerRestTemplateCustomizer)this.customizer).getServer()).withMessageContaining("Unable to return a single MockRestServiceServer since MockServerRestTemplateCustomizer has been bound to more than one RestTemplate");
    }

    @Test
    void getServerWhenSingleServerIsBoundShouldReturnServer() {
        RestTemplate template = new RestTemplate();
        this.customizer.customize(template);
        Assertions.assertThat((Object)this.customizer.getServer()).isEqualTo((Object)this.customizer.getServer(template));
    }

    @Test
    void getServerWhenRestTemplateIsFoundShouldReturnServer() {
        RestTemplate template1 = new RestTemplate();
        RestTemplate template2 = new RestTemplate();
        this.customizer.customize(template1);
        this.customizer.customize(template2);
        Assertions.assertThat((Object)this.customizer.getServer(template1)).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.customizer.getServer(template2)).isNotNull()).isNotSameAs((Object)this.customizer.getServer(template1));
    }

    @Test
    void getServerWhenRestTemplateIsNotFoundShouldReturnNull() {
        RestTemplate template1 = new RestTemplate();
        RestTemplate template2 = new RestTemplate();
        this.customizer.customize(template1);
        Assertions.assertThat((Object)this.customizer.getServer(template1)).isNotNull();
        Assertions.assertThat((Object)this.customizer.getServer(template2)).isNull();
    }

    @Test
    void getServersShouldReturnServers() {
        RestTemplate template1 = new RestTemplate();
        RestTemplate template2 = new RestTemplate();
        this.customizer.customize(template1);
        this.customizer.customize(template2);
        Assertions.assertThat((Map)this.customizer.getServers()).containsOnlyKeys((Object[])new RestTemplate[]{template1, template2});
    }

    @Test
    void getExpectationManagersShouldReturnExpectationManagers() {
        RestTemplate template1 = new RestTemplate();
        RestTemplate template2 = new RestTemplate();
        this.customizer.customize(template1);
        this.customizer.customize(template2);
        RequestExpectationManager manager1 = (RequestExpectationManager)this.customizer.getExpectationManagers().get(template1);
        RequestExpectationManager manager2 = (RequestExpectationManager)this.customizer.getExpectationManagers().get(template2);
        Assertions.assertThat((Object)this.customizer.getServer(template1)).extracting("expectationManager").isEqualTo((Object)manager1);
        Assertions.assertThat((Object)this.customizer.getServer(template2)).extracting("expectationManager").isEqualTo((Object)manager2);
    }
}

