/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.web.client.RootUriRequestExpectationManager;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.web.client.RestTemplate;

class RootUriRequestExpectationManagerTests {
    private String uri = "https://example.com";
    @Mock
    private RequestExpectationManager delegate;
    private RootUriRequestExpectationManager manager;
    @Captor
    private ArgumentCaptor<ClientHttpRequest> requestCaptor;

    RootUriRequestExpectationManagerTests() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.manager = new RootUriRequestExpectationManager(this.uri, this.delegate);
    }

    @Test
    void createWhenRootUriIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RootUriRequestExpectationManager(null, this.delegate)).withMessageContaining("RootUri must not be null");
    }

    @Test
    void createWhenExpectationManagerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new RootUriRequestExpectationManager(this.uri, null)).withMessageContaining("ExpectationManager must not be null");
    }

    @Test
    void expectRequestShouldDelegateToExpectationManager() {
        ExpectedCount count = ExpectedCount.once();
        RequestMatcher requestMatcher = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        this.manager.expectRequest(count, requestMatcher);
        ((RequestExpectationManager)Mockito.verify((Object)this.delegate)).expectRequest(count, requestMatcher);
    }

    @Test
    void validateRequestWhenUriDoesNotStartWithRootUriShouldDelegateToExpectationManager() throws Exception {
        ClientHttpRequest request = (ClientHttpRequest)Mockito.mock(ClientHttpRequest.class);
        BDDMockito.given((Object)request.getURI()).willReturn((Object)new URI("https://spring.io/test"));
        this.manager.validateRequest(request);
        ((RequestExpectationManager)Mockito.verify((Object)this.delegate)).validateRequest(request);
    }

    @Test
    void validateRequestWhenUriStartsWithRootUriShouldReplaceUri() throws Exception {
        ClientHttpRequest request = (ClientHttpRequest)Mockito.mock(ClientHttpRequest.class);
        BDDMockito.given((Object)request.getURI()).willReturn((Object)new URI(this.uri + "/hello"));
        this.manager.validateRequest(request);
        ((RequestExpectationManager)Mockito.verify((Object)this.delegate)).validateRequest((ClientHttpRequest)this.requestCaptor.capture());
        HttpRequestWrapper actual = (HttpRequestWrapper)this.requestCaptor.getValue();
        Assertions.assertThat((Object)actual.getRequest()).isSameAs((Object)request);
        Assertions.assertThat((URI)actual.getURI()).isEqualTo((Object)new URI("/hello"));
    }

    @Test
    void validateRequestWhenRequestUriAssertionIsThrownShouldReplaceUriInMessage() throws Exception {
        ClientHttpRequest request = (ClientHttpRequest)Mockito.mock(ClientHttpRequest.class);
        BDDMockito.given((Object)request.getURI()).willReturn((Object)new URI(this.uri + "/hello"));
        BDDMockito.given((Object)this.delegate.validateRequest((ClientHttpRequest)ArgumentMatchers.any(ClientHttpRequest.class))).willThrow(new Throwable[]{new AssertionError((Object)"Request URI expected:</hello> was:<https://example.com/bad>")});
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> this.manager.validateRequest(request)).withMessageContaining("Request URI expected:<https://example.com/hello>");
    }

    @Test
    void resetRequestShouldDelegateToExpectationManager() {
        this.manager.reset();
        ((RequestExpectationManager)Mockito.verify((Object)this.delegate)).reset();
    }

    @Test
    void bindToShouldReturnMockRestServiceServer() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        MockRestServiceServer bound = RootUriRequestExpectationManager.bindTo((RestTemplate)restTemplate);
        Assertions.assertThat((Object)bound).isNotNull();
    }

    @Test
    void bindToWithExpectationManagerShouldReturnMockRestServiceServer() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        MockRestServiceServer bound = RootUriRequestExpectationManager.bindTo((RestTemplate)restTemplate, (RequestExpectationManager)this.delegate);
        Assertions.assertThat((Object)bound).isNotNull();
    }

    @Test
    void forRestTemplateWhenUsingRootUriTemplateHandlerShouldReturnRootUriRequestExpectationManager() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(this.uri).build();
        RequestExpectationManager actual = RootUriRequestExpectationManager.forRestTemplate((RestTemplate)restTemplate, (RequestExpectationManager)this.delegate);
        Assertions.assertThat((Object)actual).isInstanceOf(RootUriRequestExpectationManager.class);
        Assertions.assertThat((Object)actual).extracting("rootUri").isEqualTo((Object)this.uri);
    }

    @Test
    void forRestTemplateWhenNotUsingRootUriTemplateHandlerShouldReturnOriginalRequestExpectationManager() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        RequestExpectationManager actual = RootUriRequestExpectationManager.forRestTemplate((RestTemplate)restTemplate, (RequestExpectationManager)this.delegate);
        Assertions.assertThat((Object)actual).isSameAs((Object)this.delegate);
    }

    @Test
    void boundRestTemplateShouldPrefixRootUri() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("https://example.com").build();
        MockRestServiceServer server = RootUriRequestExpectationManager.bindTo((RestTemplate)restTemplate);
        server.expect(MockRestRequestMatchers.requestTo((String)"/hello")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess());
        restTemplate.getForEntity("/hello", String.class, new Object[0]);
    }

    @Test
    void boundRestTemplateWhenUrlIncludesDomainShouldNotPrefixRootUri() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri("https://example.com").build();
        MockRestServiceServer server = RootUriRequestExpectationManager.bindTo((RestTemplate)restTemplate);
        server.expect(MockRestRequestMatchers.requestTo((String)"/hello")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess());
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> restTemplate.getForEntity("https://spring.io/hello", String.class, new Object[0])).withMessageContaining("expected:<https://example.com/hello> but was:<https://spring.io/hello>");
    }
}

