/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.NoTestRestTemplateBeanChecker;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
class TestRestTemplateContextCustomizerWithOverrideIntegrationTests {
    @Autowired
    private TestRestTemplate restTemplate;

    TestRestTemplateContextCustomizerWithOverrideIntegrationTests() {
    }

    @Test
    void test() {
        Assertions.assertThat((Object)this.restTemplate).isInstanceOf(CustomTestRestTemplate.class);
    }

    static class CustomTestRestTemplate
    extends TestRestTemplate {
        CustomTestRestTemplate() {
            super(new TestRestTemplate.HttpClientOption[0]);
        }
    }

    static class TestServlet
    extends GenericServlet {
        TestServlet() {
        }

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            try (PrintWriter writer = response.getWriter();){
                writer.println("hello");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={TestServlet.class, NoTestRestTemplateBeanChecker.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        TomcatServletWebServerFactory webServerFactory() {
            return new TomcatServletWebServerFactory(0);
        }

        @Bean
        TestRestTemplate template() {
            return new CustomTestRestTemplate();
        }
    }
}

