/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.Base64Utils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

class TestRestTemplateTests {
    TestRestTemplateTests() {
    }

    @Test
    void fromRestTemplateBuilder() {
        RestTemplateBuilder builder = (RestTemplateBuilder)Mockito.mock(RestTemplateBuilder.class);
        RestTemplate delegate = new RestTemplate();
        BDDMockito.given((Object)builder.build()).willReturn((Object)delegate);
        Assertions.assertThat((Object)new TestRestTemplate(builder).getRestTemplate()).isEqualTo((Object)delegate);
    }

    @Test
    void simple() {
        Assertions.assertThat((Object)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getRestTemplate().getRequestFactory()).isInstanceOf(HttpComponentsClientHttpRequestFactory.class);
    }

    @Test
    void doNotReplaceCustomRequestFactory() {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(OkHttp3ClientHttpRequestFactory.class);
        TestRestTemplate testRestTemplate = new TestRestTemplate(builder);
        Assertions.assertThat((Object)testRestTemplate.getRestTemplate().getRequestFactory()).isInstanceOf(OkHttp3ClientHttpRequestFactory.class);
    }

    @Test
    void useTheSameRequestFactoryClassWithBasicAuth() {
        OkHttp3ClientHttpRequestFactory customFactory = new OkHttp3ClientHttpRequestFactory();
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> customFactory);
        TestRestTemplate testRestTemplate = new TestRestTemplate(builder).withBasicAuth("test", "test");
        RestTemplate restTemplate = testRestTemplate.getRestTemplate();
        Assertions.assertThat((String)restTemplate.getRequestFactory().getClass().getName()).contains(new CharSequence[]{"RestTemplateBuilderClientHttpRequestFactoryWrapper"});
        Object requestFactory = ReflectionTestUtils.getField((Object)restTemplate.getRequestFactory(), (String)"requestFactory");
        ((ObjectAssert)Assertions.assertThat((Object)requestFactory).isEqualTo((Object)customFactory)).hasSameClassAs((Object)customFactory);
    }

    @Test
    void getRootUriRootUriSetViaRestTemplateBuilder() {
        String rootUri = "https://example.com";
        RestTemplateBuilder delegate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(rootUri);
        Assertions.assertThat((String)new TestRestTemplate(delegate).getRootUri()).isEqualTo(rootUri);
    }

    @Test
    void getRootUriRootUriSetViaLocalHostUriTemplateHandler() {
        String rootUri = "https://example.com";
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        LocalHostUriTemplateHandler templateHandler = (LocalHostUriTemplateHandler)Mockito.mock(LocalHostUriTemplateHandler.class);
        BDDMockito.given((Object)templateHandler.getRootUri()).willReturn((Object)rootUri);
        template.setUriTemplateHandler((UriTemplateHandler)templateHandler);
        Assertions.assertThat((String)template.getRootUri()).isEqualTo(rootUri);
    }

    @Test
    void getRootUriRootUriNotSet() {
        Assertions.assertThat((String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getRootUri()).isEqualTo("");
    }

    @Test
    void authenticated() throws Exception {
        TestRestTemplate restTemplate = new TestRestTemplate("user", "password", new TestRestTemplate.HttpClientOption[0]);
        this.assertBasicAuthorizationCredentials(restTemplate, "user", "password");
    }

    @Test
    void options() {
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[]{TestRestTemplate.HttpClientOption.ENABLE_REDIRECTS});
        TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory factory = (TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory)template.getRestTemplate().getRequestFactory();
        RequestConfig config = factory.getRequestConfig();
        Assertions.assertThat((boolean)config.isRedirectsEnabled()).isTrue();
    }

    @Test
    void restOperationsAreAvailable() {
        RestTemplate delegate = (RestTemplate)Mockito.mock(RestTemplate.class);
        BDDMockito.given((Object)delegate.getRequestFactory()).willReturn((Object)new SimpleClientHttpRequestFactory());
        BDDMockito.given((Object)delegate.getUriTemplateHandler()).willReturn((Object)new DefaultUriBuilderFactory());
        RestTemplateBuilder builder = (RestTemplateBuilder)Mockito.mock(RestTemplateBuilder.class);
        BDDMockito.given((Object)builder.build()).willReturn((Object)delegate);
        final TestRestTemplate restTemplate = new TestRestTemplate(builder);
        ReflectionUtils.doWithMethods(RestOperations.class, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Method equivalent = ReflectionUtils.findMethod(TestRestTemplate.class, (String)method.getName(), (Class[])method.getParameterTypes());
                ((ObjectAssert)Assertions.assertThat((Object)equivalent).as("Method %s not found", new Object[]{method})).isNotNull();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)Modifier.isPublic(equivalent.getModifiers())).as("Method %s should have been public", new Object[]{equivalent})).isTrue();
                try {
                    equivalent.invoke((Object)restTemplate, this.mockArguments(method.getParameterTypes()));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            private Object[] mockArguments(Class<?>[] parameterTypes) throws Exception {
                Object[] arguments = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    arguments[i] = this.mockArgument(parameterTypes[i]);
                }
                return arguments;
            }

            private Object mockArgument(Class<?> type) throws Exception {
                if (String.class.equals(type)) {
                    return "String";
                }
                if (Object[].class.equals(type)) {
                    return new Object[0];
                }
                if (URI.class.equals(type)) {
                    return new URI("http://localhost");
                }
                if (HttpMethod.class.equals(type)) {
                    return HttpMethod.GET;
                }
                if (Class.class.equals(type)) {
                    return Object.class;
                }
                if (RequestEntity.class.equals(type)) {
                    return new RequestEntity(HttpMethod.GET, new URI("http://localhost"));
                }
                return Mockito.mock(type);
            }
        }, method -> Modifier.isPublic(method.getModifiers()));
    }

    @Test
    void withBasicAuthAddsBasicAuthClientFactoryWhenNotAlreadyPresent() throws Exception {
        TestRestTemplate original = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        TestRestTemplate basicAuth = original.withBasicAuth("user", "password");
        Assertions.assertThat(this.getConverterClasses(original)).containsExactlyElementsOf(this.getConverterClasses(basicAuth));
        Assertions.assertThat((String)basicAuth.getRestTemplate().getRequestFactory().getClass().getName()).contains(new CharSequence[]{"RestTemplateBuilderClientHttpRequestFactoryWrapper"});
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)basicAuth.getRestTemplate().getRequestFactory(), (String)"requestFactory")).isInstanceOf(TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory.class);
        Assertions.assertThat((List)basicAuth.getRestTemplate().getInterceptors()).isEmpty();
        this.assertBasicAuthorizationCredentials(basicAuth, "user", "password");
    }

    @Test
    void withBasicAuthReplacesBasicAuthClientFactoryWhenAlreadyPresent() throws Exception {
        TestRestTemplate original = new TestRestTemplate("foo", "bar", new TestRestTemplate.HttpClientOption[0]).withBasicAuth("replace", "replace");
        TestRestTemplate basicAuth = original.withBasicAuth("user", "password");
        Assertions.assertThat(this.getConverterClasses(basicAuth)).containsExactlyElementsOf(this.getConverterClasses(original));
        Assertions.assertThat((String)basicAuth.getRestTemplate().getRequestFactory().getClass().getName()).contains(new CharSequence[]{"RestTemplateBuilderClientHttpRequestFactoryWrapper"});
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)basicAuth.getRestTemplate().getRequestFactory(), (String)"requestFactory")).isInstanceOf(TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory.class);
        Assertions.assertThat((List)basicAuth.getRestTemplate().getInterceptors()).isEmpty();
        this.assertBasicAuthorizationCredentials(basicAuth, "user", "password");
    }

    private List<Class<?>> getConverterClasses(TestRestTemplate testRestTemplate) {
        return testRestTemplate.getRestTemplate().getMessageConverters().stream().map(Object::getClass).collect(Collectors.toList());
    }

    @Test
    void withBasicAuthShouldUseNoOpErrorHandler() throws Exception {
        TestRestTemplate originalTemplate = new TestRestTemplate("foo", "bar", new TestRestTemplate.HttpClientOption[0]);
        ResponseErrorHandler errorHandler = (ResponseErrorHandler)Mockito.mock(ResponseErrorHandler.class);
        originalTemplate.getRestTemplate().setErrorHandler(errorHandler);
        TestRestTemplate basicAuthTemplate = originalTemplate.withBasicAuth("user", "password");
        Assertions.assertThat((Object)basicAuthTemplate.getRestTemplate().getErrorHandler()).isInstanceOf(Class.forName("org.springframework.boot.test.web.client.TestRestTemplate$NoOpResponseErrorHandler"));
    }

    @Test
    void deleteHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::delete);
    }

    @Test
    void exchangeWithRequestEntityAndClassHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(new RequestEntity(HttpMethod.GET, relativeUri), String.class));
    }

    @Test
    void exchangeWithRequestEntityAndParameterizedTypeReferenceHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(new RequestEntity(HttpMethod.GET, relativeUri), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}));
    }

    @Test
    void exchangeHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(relativeUri, HttpMethod.GET, new HttpEntity((Object)new byte[0]), String.class));
    }

    @Test
    void exchangeWithParameterizedTypeReferenceHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(relativeUri, HttpMethod.GET, new HttpEntity((Object)new byte[0]), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}));
    }

    @Test
    void executeHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.execute(relativeUri, HttpMethod.GET, null, null));
    }

    @Test
    void getForEntityHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.getForEntity(relativeUri, String.class));
    }

    @Test
    void getForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.getForObject(relativeUri, String.class);
        });
    }

    @Test
    void headForHeadersHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::headForHeaders);
    }

    @Test
    void optionsForAllowHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::optionsForAllow);
    }

    @Test
    void patchForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.patchForObject(relativeUri, (Object)"hello", String.class);
        });
    }

    @Test
    void postForEntityHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.postForEntity(relativeUri, (Object)"hello", String.class));
    }

    @Test
    void postForLocationHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.postForLocation(relativeUri, (Object)"hello"));
    }

    @Test
    void postForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.postForObject(relativeUri, (Object)"hello", String.class);
        });
    }

    @Test
    void putHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.put(relativeUri, (Object)"hello"));
    }

    private void verifyRelativeUriHandling(TestRestTemplateCallback callback) throws IOException {
        ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)Mockito.mock(ClientHttpRequestFactory.class);
        MockClientHttpRequest request = new MockClientHttpRequest();
        request.setResponse((ClientHttpResponse)new MockClientHttpResponse(new byte[0], HttpStatus.OK));
        URI absoluteUri = URI.create("http://localhost:8080/a/b/c.txt?param=%7Bsomething%7D");
        BDDMockito.given((Object)requestFactory.createRequest((URI)ArgumentMatchers.eq((Object)absoluteUri), (HttpMethod)ArgumentMatchers.any(HttpMethod.class))).willReturn((Object)request);
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        template.getRestTemplate().setRequestFactory(requestFactory);
        LocalHostUriTemplateHandler uriTemplateHandler = new LocalHostUriTemplateHandler((Environment)new MockEnvironment());
        template.setUriTemplateHandler((UriTemplateHandler)uriTemplateHandler);
        callback.doWithTestRestTemplate(template, URI.create("/a/b/c.txt?param=%7Bsomething%7D"));
        ((ClientHttpRequestFactory)Mockito.verify((Object)requestFactory)).createRequest((URI)ArgumentMatchers.eq((Object)absoluteUri), (HttpMethod)ArgumentMatchers.any(HttpMethod.class));
    }

    private void assertBasicAuthorizationCredentials(TestRestTemplate testRestTemplate, String username, String password) throws Exception {
        ClientHttpRequestFactory requestFactory = testRestTemplate.getRestTemplate().getRequestFactory();
        ClientHttpRequest request = requestFactory.createRequest(URI.create("http://localhost"), HttpMethod.POST);
        Assertions.assertThat((Map)request.getHeaders()).containsKeys((Object[])new String[]{"Authorization"});
        Assertions.assertThat((List)request.getHeaders().get((Object)"Authorization")).containsExactly((Object[])new String[]{"Basic " + Base64Utils.encodeToString((byte[])String.format("%s:%s", username, password).getBytes())});
    }

    static interface TestRestTemplateCallback {
        public void doWithTestRestTemplate(TestRestTemplate var1, URI var2);
    }
}

