/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.htmlunit;

import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import java.io.IOException;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.web.htmlunit.LocalHostWebClient;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;

class LocalHostWebClientTests {
    @Captor
    private ArgumentCaptor<WebRequest> requestCaptor;

    LocalHostWebClientTests() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    void createWhenEnvironmentIsNullWillThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostWebClient(null)).withMessageContaining("Environment must not be null");
    }

    @Test
    void getPageWhenUrlIsRelativeAndNoPortWillUseLocalhost8080() throws Exception {
        MockEnvironment environment = new MockEnvironment();
        LocalHostWebClient client = new LocalHostWebClient((Environment)environment);
        WebConnection connection = this.mockConnection();
        client.setWebConnection(connection);
        client.getPage("/test");
        ((WebConnection)Mockito.verify((Object)connection)).getResponse((WebRequest)this.requestCaptor.capture());
        Assertions.assertThat((URL)((WebRequest)this.requestCaptor.getValue()).getUrl()).isEqualTo((Object)new URL("http://localhost:8080/test"));
    }

    @Test
    void getPageWhenUrlIsRelativeAndHasPortWillUseLocalhostPort() throws Exception {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("local.server.port", "8181");
        LocalHostWebClient client = new LocalHostWebClient((Environment)environment);
        WebConnection connection = this.mockConnection();
        client.setWebConnection(connection);
        client.getPage("/test");
        ((WebConnection)Mockito.verify((Object)connection)).getResponse((WebRequest)this.requestCaptor.capture());
        Assertions.assertThat((URL)((WebRequest)this.requestCaptor.getValue()).getUrl()).isEqualTo((Object)new URL("http://localhost:8181/test"));
    }

    private WebConnection mockConnection() throws IOException {
        WebConnection connection = (WebConnection)Mockito.mock(WebConnection.class);
        StringWebResponse response = new StringWebResponse("test", new URL("http://localhost"));
        BDDMockito.given((Object)connection.getResponse((WebRequest)ArgumentMatchers.any())).willReturn((Object)response);
        return connection;
    }
}

