/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.bind.PropertyNamePatternsMatcher;

class DefaultPropertyNamePatternsMatcher
implements PropertyNamePatternsMatcher {
    private final String[] names;

    public DefaultPropertyNamePatternsMatcher(String ... names) {
        this(new HashSet<String>(Arrays.asList(names)));
    }

    public DefaultPropertyNamePatternsMatcher(Set<String> names) {
        this.names = names.toArray(new String[names.size()]);
    }

    @Override
    public boolean matches(String propertyName) {
        int i;
        char[] propertNameChars = propertyName.toCharArray();
        boolean[] match = new boolean[this.names.length];
        boolean noneMatched = true;
        for (i = 0; i < this.names.length; ++i) {
            if (this.names[i].length() > propertNameChars.length) continue;
            match[i] = true;
            noneMatched = false;
        }
        if (noneMatched) {
            return false;
        }
        for (int charIndex = 0; charIndex < propertNameChars.length; ++charIndex) {
            noneMatched = true;
            for (int nameIndex = 0; nameIndex < this.names.length; ++nameIndex) {
                if (!match[nameIndex]) continue;
                if (charIndex < this.names[nameIndex].length()) {
                    if (this.names[nameIndex].charAt(charIndex) != propertNameChars[charIndex]) continue;
                    match[nameIndex] = true;
                    noneMatched = false;
                    continue;
                }
                char charAfter = propertNameChars[this.names[nameIndex].length()];
                if (charAfter != '.' && charAfter != '_') continue;
                match[nameIndex] = true;
                noneMatched = false;
            }
            if (!noneMatched) continue;
            return false;
        }
        for (i = 0; i < match.length; ++i) {
            if (!match[i]) continue;
            return true;
        }
        return false;
    }
}

