/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.test.Base64Encoder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class TestRestTemplate
extends RestTemplate {
    public TestRestTemplate(HttpClientOption ... httpClientOptions) {
        this((String)null, (String)null, httpClientOptions);
    }

    public TestRestTemplate(String username, String password, HttpClientOption ... httpClientOptions) {
        if (ClassUtils.isPresent((String)"org.apache.http.client.config.RequestConfig", null)) {
            this.setRequestFactory((ClientHttpRequestFactory)new CustomHttpComponentsClientHttpRequestFactory(httpClientOptions));
        }
        this.addAuthentication(username, password);
        this.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
            }
        });
    }

    private void addAuthentication(String username, String password) {
        if (username == null) {
            return;
        }
        List<BasicAuthorizationInterceptor> interceptors = Collections.singletonList(new BasicAuthorizationInterceptor(username, password));
        this.setRequestFactory((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory(this.getRequestFactory(), interceptors));
    }

    protected static class CustomHttpComponentsClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory {
        private final String cookieSpec;
        private final boolean enableRedirects;

        public CustomHttpComponentsClientHttpRequestFactory(HttpClientOption[] httpClientOptions) {
            HashSet<HttpClientOption> options = new HashSet<HttpClientOption>(Arrays.asList(httpClientOptions));
            this.cookieSpec = options.contains((Object)HttpClientOption.ENABLE_COOKIES) ? "standard" : "ignoreCookies";
            this.enableRedirects = options.contains((Object)HttpClientOption.ENABLE_REDIRECTS);
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(this.getRequestConfig());
            return context;
        }

        protected RequestConfig getRequestConfig() {
            RequestConfig.Builder builder = RequestConfig.custom().setCookieSpec(this.cookieSpec).setAuthenticationEnabled(false).setRedirectsEnabled(this.enableRedirects);
            return builder.build();
        }
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private final String username;
        private final String password;

        public BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            String token = Base64Encoder.encode(this.username + ":" + this.password);
            request.getHeaders().add("Authorization", "Basic " + token);
            return execution.execute(request, body);
        }
    }

    public static enum HttpClientOption {
        ENABLE_COOKIES,
        ENABLE_REDIRECTS;

    }
}

