/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.cloud.aws.messaging.endpoint.config.NotificationHandlerMethodArgumentResolverConfigurationUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class SnsConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired(required=false)
    private AWSCredentialsProvider awsCredentialsProvider;
    @Autowired(required=false)
    private RegionProvider regionProvider;

    @ConditionalOnMissingAmazonClient(value=AmazonSNS.class)
    @Bean
    public AmazonSNS amazonSNS() {
        AmazonSNSClient amazonSNSClient = this.awsCredentialsProvider != null ? new AmazonSNSClient(this.awsCredentialsProvider) : new AmazonSNSClient();
        if (this.regionProvider != null) {
            amazonSNSClient.setRegion(this.regionProvider.getRegion());
        }
        return amazonSNSClient;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(NotificationHandlerMethodArgumentResolverConfigurationUtils.getNotificationHandlerMethodArgumentResolver(this.amazonSNS()));
    }
}

