/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.services.sns.AmazonSNS;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.TopicMessageChannel;
import org.springframework.cloud.aws.messaging.core.support.AbstractMessageChannelMessagingSendingTemplate;
import org.springframework.cloud.aws.messaging.support.destination.DynamicTopicDestinationResolver;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public class NotificationMessagingTemplate
extends AbstractMessageChannelMessagingSendingTemplate<TopicMessageChannel> {
    private final AmazonSNS amazonSns;

    public NotificationMessagingTemplate(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver) {
        super(new DynamicTopicDestinationResolver(amazonSns, resourceIdResolver));
        this.amazonSns = amazonSns;
        this.initMessageConverter();
    }

    private void initMessageConverter() {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        this.setMessageConverter((MessageConverter)stringMessageConverter);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns) {
        this(amazonSns, null);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload) throws MessagingException {
        Assert.isInstanceOf(String.class, payload, (String)"Payload must be of type string");
        super.convertAndSend(destinationName, payload);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers) throws MessagingException {
        Assert.isInstanceOf(String.class, payload, (String)"Payload must be of type string");
        super.convertAndSend(destinationName, payload, headers);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, MessagePostProcessor postProcessor) throws MessagingException {
        Assert.isInstanceOf(String.class, payload, (String)"Payload must be of type string");
        super.convertAndSend(destinationName, payload, postProcessor);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers, MessagePostProcessor postProcessor) throws MessagingException {
        Assert.isInstanceOf(String.class, payload, (String)"Payload must be of type string");
        super.convertAndSend(destinationName, payload, headers, postProcessor);
    }

    @Override
    protected TopicMessageChannel resolveMessageChannel(String physicalResourceIdentifier) {
        return new TopicMessageChannel(this.amazonSns, physicalResourceIdentifier);
    }

    public void sendNotification(String destinationName, String message, String subject) {
        this.convertAndSend(destinationName, message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }

    public void sendNotification(String message, String subject) {
        this.convertAndSend(this.getRequiredDefaultDestination(), message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }
}

