/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={DiscoveryClient.class})
@ConditionalOnProperty(value={"spring.cloud.discovery.enabled"}, matchIfMissing=true)
@AutoConfigureOrder(value=0)
public class CommonsClientAutoConfiguration {
    @Bean
    public DiscoveryClientHealthIndicator discoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        return new DiscoveryClientHealthIndicator(discoveryClient);
    }

    @Bean
    public DiscoveryCompositeHealthIndicator discoveryCompositeHealthIndicator(HealthAggregator aggregator, List<DiscoveryHealthIndicator> indicators) {
        return new DiscoveryCompositeHealthIndicator(aggregator, indicators);
    }

    @Bean
    public HasFeatures commonsFeatures() {
        return HasFeatures.abstractFeatures(DiscoveryClient.class, LoadBalancerClient.class);
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class ActuatorConfiguration {
        @Autowired(required=false)
        private List<HasFeatures> hasFeatures = new ArrayList<HasFeatures>();

        protected ActuatorConfiguration() {
        }

        @Bean
        public FeaturesEndpoint featuresEndpoint() {
            return new FeaturesEndpoint(this.hasFeatures);
        }
    }
}

