/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.actuator;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.actuator.NamedFeature;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@ConfigurationProperties(prefix="endpoints.features", ignoreUnknownFields=false)
public class FeaturesEndpoint
extends AbstractEndpoint<Features>
implements ApplicationContextAware {
    private final List<HasFeatures> hasFeaturesList;
    private ApplicationContext context;

    public FeaturesEndpoint(List<HasFeatures> hasFeaturesList) {
        super("features", false);
        this.hasFeaturesList = hasFeaturesList;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public Features invoke() {
        Features features = new Features();
        for (HasFeatures hasFeatures : this.hasFeaturesList) {
            List<NamedFeature> namedFeatures;
            List<Class> abstractFeatures = hasFeatures.getAbstractFeatures();
            if (abstractFeatures != null) {
                for (Class clazz : abstractFeatures) {
                    this.addAbstractFeature(features, clazz);
                }
            }
            if ((namedFeatures = hasFeatures.getNamedFeatures()) == null) continue;
            for (NamedFeature namedFeature : namedFeatures) {
                this.addFeature(features, namedFeature);
            }
        }
        return features;
    }

    private void addAbstractFeature(Features features, Class type) {
        String featureName = type.getSimpleName();
        try {
            Object bean = this.context.getBean(type);
            Class<?> beanClass = bean.getClass();
            this.addFeature(features, new NamedFeature(featureName, beanClass));
        }
        catch (NoSuchBeanDefinitionException e) {
            features.getDisabled().add(featureName);
        }
    }

    private void addFeature(Features features, NamedFeature feature) {
        Class<?> type = feature.getType();
        features.getEnabled().add(new Feature(feature.getName(), type.getCanonicalName(), type.getPackage().getImplementationVersion(), type.getPackage().getImplementationVendor()));
    }

    final class Feature {
        private final String type;
        private final String name;
        private final String version;
        private final String vendor;

        @ConstructorProperties(value={"type", "name", "version", "vendor"})
        public Feature(String type, String name, String version, String vendor) {
            this.type = type;
            this.name = name;
            this.version = version;
            this.vendor = vendor;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Feature)) {
                return false;
            }
            Feature other = (Feature)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            return !(this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            return result;
        }

        public String toString() {
            return "FeaturesEndpoint.Feature(type=" + this.getType() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", vendor=" + this.getVendor() + ")";
        }
    }

    final class Features {
        private final List<Feature> enabled = new ArrayList<Feature>();
        private final List<String> disabled = new ArrayList<String>();

        public List<Feature> getEnabled() {
            return this.enabled;
        }

        public List<String> getDisabled() {
            return this.disabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Features)) {
                return false;
            }
            Features other = (Features)o;
            List<Feature> this$enabled = this.getEnabled();
            List<Feature> other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            List<String> this$disabled = this.getDisabled();
            List<String> other$disabled = other.getDisabled();
            return !(this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Feature> $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            List<String> $disabled = this.getDisabled();
            result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
            return result;
        }

        public String toString() {
            return "FeaturesEndpoint.Features(enabled=" + this.getEnabled() + ", disabled=" + this.getDisabled() + ")";
        }
    }
}

