/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InetUtils {
    private static final Log log = LogFactory.getLog(InetUtils.class);

    public static HostInfo getFirstNonLoopbackHostInfo() {
        InetAddress address = InetUtils.getFirstNonLoopbackAddress();
        if (address != null) {
            return InetUtils.convert(address);
        }
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostname("localhost");
        hostInfo.setIpAddress("127.0.0.1");
        return hostInfo;
    }

    public static InetAddress getFirstNonLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> enumNic = NetworkInterface.getNetworkInterfaces();
            while (enumNic.hasMoreElements()) {
                NetworkInterface ifc = enumNic.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> enumAddr = ifc.getInetAddresses();
                while (enumAddr.hasMoreElements()) {
                    InetAddress address = enumAddr.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    return address;
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)"Cannot get first non-loopback address", (Throwable)ex);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Unable to retrieve localhost");
            return null;
        }
    }

    public static HostInfo convert(InetAddress address) {
        HostInfo hostInfo = new HostInfo();
        hostInfo.setHostname(address.getHostName());
        hostInfo.setIpAddress(address.getHostAddress());
        return hostInfo;
    }

    public static final class HostInfo {
        public boolean override;
        private String ipAddress;
        private String hostname;

        public int getIpAddressAsInt() {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(this.ipAddress);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
        }

        public boolean isOverride() {
            return this.override;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostInfo)) {
                return false;
            }
            HostInfo other = (HostInfo)o;
            if (this.isOverride() != other.isOverride()) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOverride() ? 79 : 97);
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            return result;
        }

        public String toString() {
            return "InetUtils.HostInfo(override=" + this.isOverride() + ", ipAddress=" + this.getIpAddress() + ", hostname=" + this.getHostname() + ")";
        }
    }
}

