/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.actuator.FeaturesEndpoint;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

public class CommonsClientAutoConfigurationTests {
    @Test
    public void beansCreatedNormally() {
        try (ConfigurableApplicationContext ctxt = this.init(new String[0]);){
            Assert.assertThat((Object)ctxt.getBean(DiscoveryClientHealthIndicator.class), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)ctxt.getBean(DiscoveryCompositeHealthIndicator.class), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)ctxt.getBean(FeaturesEndpoint.class), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat(ctxt.getBeansOfType(HasFeatures.class).values(), (Matcher)Matchers.not((Matcher)Matchers.emptyCollectionOf(HasFeatures.class)));
        }
    }

    @Test
    public void disableAll() {
        try (ConfigurableApplicationContext ctxt = this.init("spring.cloud.discovery.enabled=false");){
            this.assertBeanNonExistant(ctxt, DiscoveryClientHealthIndicator.class);
            this.assertBeanNonExistant(ctxt, DiscoveryCompositeHealthIndicator.class);
            Assert.assertThat((Object)ctxt.getBean(FeaturesEndpoint.class), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            this.assertBeanNonExistant(ctxt, HasFeatures.class);
        }
    }

    @Test
    public void disableAllIndividually() {
        try (ConfigurableApplicationContext ctxt = this.init("spring.cloud.discovery.client.health-indicator.enabled=false", "spring.cloud.discovery.client.composite-indicator.enabled=false", "spring.cloud.features.enabled=false");){
            this.assertBeanNonExistant(ctxt, DiscoveryClientHealthIndicator.class);
            this.assertBeanNonExistant(ctxt, DiscoveryCompositeHealthIndicator.class);
            this.assertBeanNonExistant(ctxt, FeaturesEndpoint.class);
        }
    }

    @Test
    public void disableHealthIndicator() {
        try (ConfigurableApplicationContext ctxt = this.init("spring.cloud.discovery.client.health-indicator.enabled=false");){
            this.assertBeanNonExistant(ctxt, DiscoveryClientHealthIndicator.class);
            this.assertBeanNonExistant(ctxt, DiscoveryCompositeHealthIndicator.class);
        }
    }

    private void assertBeanNonExistant(ConfigurableApplicationContext ctxt, Class<?> beanClass) {
        try {
            ctxt.getBean(beanClass);
            Assert.fail((String)("Bean of type " + beanClass + " should not have been created"));
        }
        catch (BeansException beansException) {
            // empty catch block
        }
    }

    protected ConfigurableApplicationContext init(String ... pairs) {
        return new SpringApplicationBuilder(new Class[0]).web(false).sources(new Class[]{Config.class}).properties(pairs).run(new String[0]);
    }

    @Configuration
    @EnableAutoConfiguration
    @Import(value={NoopDiscoveryClientAutoConfiguration.class})
    protected static class Config {
        protected Config() {
        }
    }
}

