/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClientImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.mock.env.MockEnvironment;

public class EnableDiscoveryClientImportSelectorTests {
    private final EnableDiscoveryClientImportSelector importSelector = new EnableDiscoveryClientImportSelector();
    private final MockEnvironment environment = new MockEnvironment();
    @Mock
    private AnnotationMetadata annotationMetadata;
    @Mock
    private AnnotationAttributes annotationAttributes;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.importSelector.setBeanClassLoader(this.getClass().getClassLoader());
        this.importSelector.setEnvironment((Environment)this.environment);
    }

    @Test
    public void autoRegistrationIsEnabled() {
        this.configureAnnotation(true);
        Object[] imports = this.importSelector.selectImports(this.annotationMetadata);
        Assert.assertTrue((boolean)((Boolean)this.environment.getProperty("spring.cloud.service-registry.auto-registration.enabled", Boolean.class, (Object)true)));
        Assertions.assertThat((Object[])imports).hasSize(1);
    }

    @Test
    public void autoRegistrationIsDisabled() {
        this.configureAnnotation(false);
        Object[] imports = this.importSelector.selectImports(this.annotationMetadata);
        Assert.assertFalse((boolean)((Boolean)this.environment.getProperty("spring.cloud.service-registry.auto-registration.enabled", Boolean.class)));
        Assertions.assertThat((Object[])imports).isEmpty();
    }

    private void configureAnnotation(boolean autoRegistration) {
        String annotationName = EnableDiscoveryClient.class.getName();
        BDDMockito.given((Object)this.annotationMetadata.isAnnotated(annotationName)).willReturn((Object)true);
        BDDMockito.given((Object)this.annotationMetadata.getAnnotationAttributes(annotationName, true)).willReturn((Object)this.annotationAttributes);
        BDDMockito.given((Object)this.annotationAttributes.getBoolean("autoRegister")).willReturn((Object)autoRegistration);
    }
}

