/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.application.name=service0", "spring.cloud.discovery.client.simple.instances.service1[0].uri=http://s1-1:8080", "spring.cloud.discovery.client.simple.instances.service1[1].uri=https://s1-2:8443", "spring.cloud.discovery.client.simple.instances.service2[0].uri=https://s2-1:8080", "spring.cloud.discovery.client.simple.instances.service2[1].uri=https://s2-2:443"})
public class CompositeDiscoveryClientTests {
    @Autowired
    private DiscoveryClient discoveryClient;

    @Test
    public void getInstancesByServiceIdShouldDelegateCall() {
        Assertions.assertThat((Object)this.discoveryClient).isInstanceOf(CompositeDiscoveryClient.class);
        Assertions.assertThat((List)this.discoveryClient.getInstances("service1")).hasSize(2);
        ServiceInstance s1 = (ServiceInstance)this.discoveryClient.getInstances("service1").get(0);
        Assertions.assertThat((String)s1.getHost()).isEqualTo((Object)"s1-1");
        Assertions.assertThat((int)s1.getPort()).isEqualTo(8080);
        Assertions.assertThat((URI)s1.getUri()).isEqualTo((Object)URI.create("http://s1-1:8080"));
        Assertions.assertThat((boolean)s1.isSecure()).isEqualTo(false);
    }

    @Test
    public void getServicesShouldAggregateAllServiceNames() {
        Assertions.assertThat((List)this.discoveryClient.getServices()).containsOnlyOnce((Object[])new String[]{"service1", "service2", "custom"});
    }

    @Test
    public void getDescriptionShouldBeComposite() {
        Assertions.assertThat((String)this.discoveryClient.description()).isEqualTo((Object)"Composite Discovery Client");
    }

    @Test
    public void getInstancesShouldRespectOrder() {
        Assertions.assertThat((List)this.discoveryClient.getInstances("custom")).hasSize(1);
        Assertions.assertThat((List)this.discoveryClient.getInstances("custom")).hasSize(1);
    }

    @Test
    public void getInstancesByUnknownServiceIdShouldReturnAnEmptyList() {
        Assertions.assertThat((List)this.discoveryClient.getInstances("unknown")).hasSize(0);
    }

    @EnableAutoConfiguration
    @Configuration
    public static class Config {
        @Bean
        @Order(value=1)
        public DiscoveryClient customDiscoveryClient() {
            return new DiscoveryClient(){

                public String description() {
                    return "A custom discovery client";
                }

                public List<ServiceInstance> getInstances(String serviceId) {
                    if (serviceId.equals("custom")) {
                        DefaultServiceInstance s1 = new DefaultServiceInstance("custom", "host", 123, false);
                        return Arrays.asList(s1);
                    }
                    return Collections.emptyList();
                }

                public List<String> getServices() {
                    return Arrays.asList("custom");
                }
            };
        }
    }
}

