/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class, CommonsClientAutoConfiguration.class}, properties={"spring.cloud.discovery.client.health-indicator.include-description:true"})
public class DiscoveryClientHealthIndicatorTests {
    @Autowired
    private DiscoveryCompositeHealthIndicator healthIndicator;
    @Autowired
    private DiscoveryClientHealthIndicator clientHealthIndicator;

    @Test
    public void testHealthIndicatorDescriptionDisabled() {
        Assert.assertNotNull((String)"healthIndicator was null", (Object)this.healthIndicator);
        Health health = this.healthIndicator.health();
        this.assertHealth(health, Status.UNKNOWN);
        this.clientHealthIndicator.onApplicationEvent(new InstanceRegisteredEvent((Object)this, null));
        health = this.healthIndicator.health();
        Status status = this.assertHealth(health, Status.UP);
        Assert.assertEquals((String)"status description was wrong", (Object)"TestDiscoveryClient", (Object)status.getDescription());
    }

    private Status assertHealth(Health health, Status expected) {
        Assert.assertNotNull((String)"health was null", (Object)health);
        Status status = health.getStatus();
        Assert.assertNotNull((String)"status was null", (Object)status);
        Assert.assertEquals((String)"status code was wrong", (Object)expected.getCode(), (Object)status.getCode());
        return status;
    }

    @Configuration
    @EnableConfigurationProperties
    public static class Config {
        @Bean
        public HealthAggregator healthAggregator() {
            return new OrderedHealthAggregator();
        }

        @Bean
        public DiscoveryClient discoveryClient() {
            DiscoveryClient mock = (DiscoveryClient)Mockito.mock(DiscoveryClient.class);
            BDDMockito.given((Object)mock.description()).willReturn((Object)"TestDiscoveryClient");
            BDDMockito.given((Object)mock.getServices()).willReturn(Arrays.asList("TestService1"));
            return mock;
        }

        @Bean
        public DiscoveryHealthIndicator discoveryHealthIndicator() {
            return new DiscoveryHealthIndicator(){

                public String getName() {
                    return "testDiscoveryHealthIndicator";
                }

                public Health health() {
                    return new Health.Builder().unknown().build();
                }
            };
        }
    }
}

