/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.hypermedia.CloudHypermediaAutoConfiguration;
import org.springframework.cloud.client.hypermedia.DiscoveredResource;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.cloud.client.hypermedia.RemoteResourceRefresher;
import org.springframework.cloud.client.hypermedia.ServiceInstanceProvider;
import org.springframework.cloud.client.hypermedia.StaticServiceInstanceProvider;
import org.springframework.cloud.client.hypermedia.TraversalDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.Traverson;

public class CloudHypermediaAutoConfigurationIntegrationTests {
    @Test
    public void picksUpHypermediaProperties() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(ConfigWithRemoteResource.class);){
            CloudHypermediaAutoConfiguration.CloudHypermediaProperties properties = (CloudHypermediaAutoConfiguration.CloudHypermediaProperties)context.getBean(CloudHypermediaAutoConfiguration.CloudHypermediaProperties.class);
            Assert.assertThat((Object)properties.getRefresh().getInitialDelay(), (Matcher)Matchers.is((Object)50000));
            Assert.assertThat((Object)properties.getRefresh().getFixedDelay(), (Matcher)Matchers.is((Object)10000));
        }
    }

    @Test
    public void doesNotCreateCloudHypermediaPropertiesifNotActive() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(Config.class);){
            Assert.assertThat((Object)context.getBeanNamesForType(CloudHypermediaAutoConfiguration.CloudHypermediaProperties.class), (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)0)));
        }
    }

    @Test
    public void doesNotRegisterResourceRefresherIfNoDiscoveredResourceIsDefined() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(Config.class);){
            Assert.assertThat(context.getBeansOfType(RemoteResource.class).values(), (Matcher)Matchers.hasSize((int)0));
            Assert.assertThat((Object)context.getBeanNamesForType(RemoteResourceRefresher.class), (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)0)));
        }
    }

    @Test
    public void registersResourceRefresherIfDiscoverredResourceIsDefined() {
        try (ConfigurableApplicationContext context = CloudHypermediaAutoConfigurationIntegrationTests.getApplicationContext(ConfigWithRemoteResource.class);){
            Assert.assertThat(context.getBeansOfType(RemoteResource.class).values(), (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)context.getBean(RemoteResourceRefresher.class), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
    }

    private static ConfigurableApplicationContext getApplicationContext(Class<?> configuration) {
        return new SpringApplicationBuilder(new Class[]{configuration}).properties(new String[]{"server.port=0"}).run(new String[0]);
    }

    @Configuration
    @EnableAutoConfiguration
    static class ConfigWithRemoteResource {
        ConfigWithRemoteResource() {
        }

        @Bean
        public RemoteResource resource() {
            StaticServiceInstanceProvider provider = new StaticServiceInstanceProvider((ServiceInstance)new DefaultServiceInstance("service", "localhost", 80, false));
            return new DiscoveredResource((ServiceInstanceProvider)provider, new TraversalDefinition(){

                public Traverson.TraversalBuilder buildTraversal(Traverson traverson) {
                    return traverson.follow(new String[]{"rel"});
                }
            });
        }
    }

    @Configuration
    @EnableAutoConfiguration
    static class Config {
        Config() {
        }
    }
}

