/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLoadBalancerAutoConfigurationTests {
    @Test
    public void restTemplateGetsLoadBalancerInterceptor() {
        ConfigurableApplicationContext context = this.init(OneRestTemplate.class);
        Map restTemplates = context.getBeansOfType(RestTemplate.class);
        MatcherAssert.assertThat((Object)restTemplates, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(restTemplates.values(), (Matcher)Matchers.hasSize((int)1));
        RestTemplate restTemplate = (RestTemplate)restTemplates.values().iterator().next();
        MatcherAssert.assertThat((Object)restTemplate, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.assertLoadBalanced(restTemplate);
    }

    protected abstract void assertLoadBalanced(RestTemplate var1);

    @Test
    public void multipleRestTemplates() {
        ConfigurableApplicationContext context = this.init(TwoRestTemplates.class);
        Map restTemplates = context.getBeansOfType(RestTemplate.class);
        MatcherAssert.assertThat((Object)restTemplates, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Collection templates = restTemplates.values();
        MatcherAssert.assertThat(templates, (Matcher)Matchers.hasSize((int)2));
        TwoRestTemplates.Two two = (TwoRestTemplates.Two)context.getBean(TwoRestTemplates.Two.class);
        MatcherAssert.assertThat((Object)two.loadBalanced, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.assertLoadBalanced(two.loadBalanced);
        MatcherAssert.assertThat((Object)two.nonLoadBalanced, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)two.nonLoadBalanced.getInterceptors(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        return new SpringApplicationBuilder(new Class[0]).web(false).properties(new String[]{"spring.aop.proxyTargetClass=true"}).sources(new Class[]{config, LoadBalancerAutoConfiguration.class}).run(new String[0]);
    }

    private static class NoopLoadBalancerClient
    implements LoadBalancerClient {
        private final Random random = new Random();

        private NoopLoadBalancerClient() {
        }

        public ServiceInstance choose(String serviceId) {
            return new DefaultServiceInstance(serviceId, serviceId, this.random.nextInt(40000), false);
        }

        public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public URI reconstructURI(ServiceInstance instance, URI original) {
            return DefaultServiceInstance.getUri((ServiceInstance)instance);
        }
    }

    @Configuration
    protected static class TwoRestTemplates {
        protected TwoRestTemplates() {
        }

        @Primary
        @Bean
        RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @LoadBalanced
        @Bean
        RestTemplate loadBalancedRestTemplate() {
            return new RestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Bean
        LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory() {
            return new LoadBalancedRetryPolicyFactory.NeverRetryFactory();
        }

        @Configuration
        protected static class Two {
            @Autowired
            RestTemplate nonLoadBalanced;
            @Autowired
            @LoadBalanced
            RestTemplate loadBalanced;

            protected Two() {
            }
        }
    }

    @Configuration
    protected static class OneRestTemplate {
        protected OneRestTemplate() {
        }

        @LoadBalanced
        @Bean
        RestTemplate loadBalancedRestTemplate() {
            return new RestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Bean
        LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory() {
            return new LoadBalancedRetryPolicyFactory.NeverRetryFactory();
        }
    }
}

