/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.web.client.AsyncRestTemplate;

public class AsyncLoadBalancerAutoConfigurationTests {
    @Test
    public void restTemplateGetsLoadBalancerInterceptor() {
        ConfigurableApplicationContext context = this.init(OneRestTemplate.class);
        Map restTemplates = context.getBeansOfType(AsyncRestTemplate.class);
        MatcherAssert.assertThat((Object)restTemplates, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(restTemplates.values(), (Matcher)Matchers.hasSize((int)1));
        AsyncRestTemplate restTemplate = (AsyncRestTemplate)restTemplates.values().iterator().next();
        MatcherAssert.assertThat((Object)restTemplate, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.assertLoadBalanced(restTemplate);
    }

    private void assertLoadBalanced(AsyncRestTemplate restTemplate) {
        List interceptors = restTemplate.getInterceptors();
        MatcherAssert.assertThat((Object)interceptors, (Matcher)Matchers.hasSize((int)1));
        AsyncClientHttpRequestInterceptor interceptor = (AsyncClientHttpRequestInterceptor)interceptors.get(0);
        MatcherAssert.assertThat((Object)interceptor, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(AsyncLoadBalancerInterceptor.class)));
    }

    @Test
    public void multipleRestTemplates() {
        ConfigurableApplicationContext context = this.init(TwoRestTemplates.class);
        Map restTemplates = context.getBeansOfType(AsyncRestTemplate.class);
        MatcherAssert.assertThat((Object)restTemplates, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Collection templates = restTemplates.values();
        MatcherAssert.assertThat(templates, (Matcher)Matchers.hasSize((int)2));
        TwoRestTemplates.Two two = (TwoRestTemplates.Two)context.getBean(TwoRestTemplates.Two.class);
        MatcherAssert.assertThat((Object)two.loadBalanced, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.assertLoadBalanced(two.loadBalanced);
        MatcherAssert.assertThat((Object)two.nonLoadBalanced, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)two.nonLoadBalanced.getInterceptors(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        return new SpringApplicationBuilder(new Class[0]).web(false).properties(new String[]{"spring.aop.proxyTargetClass=true"}).sources(new Class[]{config, AsyncLoadBalancerAutoConfiguration.class}).run(new String[0]);
    }

    private static class NoopLoadBalancerClient
    implements LoadBalancerClient {
        private final Random random = new Random();

        private NoopLoadBalancerClient() {
        }

        public ServiceInstance choose(String serviceId) {
            return new DefaultServiceInstance(serviceId, serviceId, this.random.nextInt(40000), false);
        }

        public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
            try {
                return (T)request.apply(this.choose(serviceId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public URI reconstructURI(ServiceInstance instance, URI original) {
            return DefaultServiceInstance.getUri((ServiceInstance)instance);
        }
    }

    @Configuration
    protected static class TwoRestTemplates {
        protected TwoRestTemplates() {
        }

        @Primary
        @Bean
        AsyncRestTemplate restTemplate() {
            return new AsyncRestTemplate();
        }

        @LoadBalanced
        @Bean
        AsyncRestTemplate loadBalancedRestTemplate() {
            return new AsyncRestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Configuration
        protected static class Two {
            @Autowired
            AsyncRestTemplate nonLoadBalanced;
            @Autowired
            @LoadBalanced
            AsyncRestTemplate loadBalanced;

            protected Two() {
            }
        }
    }

    @Configuration
    protected static class OneRestTemplate {
        protected OneRestTemplate() {
        }

        @LoadBalanced
        @Bean
        AsyncRestTemplate loadBalancedRestTemplate() {
            return new AsyncRestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Bean
        LoadBalancedRetryPolicyFactory loadBalancedRetryPolicyFactory() {
            return new LoadBalancedRetryPolicyFactory.NeverRetryFactory();
        }
    }
}

