/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicyFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRetryProperties;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class RetryLoadBalancerInterceptorTest {
    private LoadBalancerClient client;
    private LoadBalancerRetryProperties lbProperties;
    private LoadBalancerRequestFactory lbRequestFactory;

    @Before
    public void setUp() throws Exception {
        this.client = (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        this.lbProperties = new LoadBalancerRetryProperties();
        this.lbRequestFactory = (LoadBalancerRequestFactory)Mockito.mock(LoadBalancerRequestFactory.class);
    }

    @After
    public void tearDown() throws Exception {
        this.client = null;
        this.lbProperties = null;
    }

    @Test(expected=IOException.class)
    public void interceptDisableRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn(null);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()});
        this.lbProperties.setEnabled(false);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)org.mockito.Matchers.any(), (byte[])org.mockito.Matchers.any(), (ClientHttpRequestExecution)org.mockito.Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test(expected=IllegalStateException.class)
    public void interceptInvalidHost() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo_underscore"));
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
    }

    @Test
    public void interceptNeverRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn(null);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)org.mockito.Matchers.any(), (byte[])org.mockito.Matchers.any(), (ClientHttpRequestExecution)org.mockito.Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptSuccess() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(request, policy, (ServiceInstanceChooser)this.client, "foo");
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)org.mockito.Matchers.any(), (byte[])org.mockito.Matchers.any(), (ClientHttpRequestExecution)org.mockito.Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        MatcherAssert.assertThat((Object)rsp, (Matcher)Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        InputStream notFoundStream = (InputStream)Mockito.mock(InputStream.class);
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse(notFoundStream, HttpStatus.NOT_FOUND);
        MockClientHttpResponse clientHttpResponseOk = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(org.mockito.Matchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)org.mockito.Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(request, policy, (ServiceInstanceChooser)this.client, "foo");
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponseNotFound).thenReturn((Object)clientHttpResponseOk);
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class));
        ((InputStream)Mockito.verify((Object)notFoundStream, (VerificationMode)Mockito.times((int)1))).close();
        MatcherAssert.assertThat((Object)rsp, (Matcher)Matchers.is((Object)clientHttpResponseOk));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)org.mockito.Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)org.mockito.Matchers.any(), (byte[])org.mockito.Matchers.any(), (ClientHttpRequestExecution)org.mockito.Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class));
        MatcherAssert.assertThat((Object)rsp, (Matcher)Matchers.is((Object)clientHttpResponse));
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
    }

    @Test(expected=IOException.class)
    public void interceptFailedRetry() throws Exception {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)org.mockito.Matchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        LoadBalancedRetryPolicyFactory lbRetryPolicyFactory = (LoadBalancedRetryPolicyFactory)Mockito.mock(LoadBalancedRetryPolicyFactory.class);
        Mockito.when((Object)lbRetryPolicyFactory.create((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstanceChooser)org.mockito.Matchers.any(ServiceInstanceChooser.class))).thenReturn((Object)policy);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)org.mockito.Matchers.eq((Object)"foo"))).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)org.mockito.Matchers.eq((Object)"foo"), (ServiceInstance)org.mockito.Matchers.eq((Object)serviceInstance), (LoadBalancerRequest)org.mockito.Matchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)org.mockito.Matchers.any(), (byte[])org.mockito.Matchers.any(), (ClientHttpRequestExecution)org.mockito.Matchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.lbProperties.setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.lbProperties, lbRetryPolicyFactory, this.lbRequestFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }
}

