/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={TestConfiguration.class}, properties={"endpoints.default.web.enabled=true"})
public class ServiceRegistryEndpointTests {
    private static final String UPDATED_STATUS = "updatedstatus";
    private static final String MYSTATUS = "mystatus";
    @Autowired
    private WebApplicationContext context;
    @Autowired
    private TestServiceRegistry serviceRegistry;
    private MockMvc mvc;

    @Before
    public void setUp() {
        this.mvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).build();
    }

    @Test
    public void testGet() throws Exception {
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/application/service-registry", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)MYSTATUS)));
    }

    @Test
    public void testPost() throws Exception {
        Map<String, String> status = Collections.singletonMap("status", UPDATED_STATUS);
        this.mvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/application/service-registry", (Object[])new Object[0]).content(new ObjectMapper().writeValueAsString(status)).contentType(MediaType.APPLICATION_JSON)).andExpect(MockMvcResultMatchers.status().isOk());
        Assertions.assertThat((String)this.serviceRegistry.getUpdatedStatus().get()).isEqualTo((Object)UPDATED_STATUS);
    }

    static class TestServiceRegistry
    implements ServiceRegistry {
        AtomicReference<String> updatedStatus = new AtomicReference();

        TestServiceRegistry() {
        }

        public void register(Registration registration) {
        }

        public void deregister(Registration registration) {
        }

        public void close() {
        }

        public void setStatus(Registration registration, String status) {
            this.updatedStatus.compareAndSet(null, status);
        }

        public Object getStatus(Registration registration) {
            return ServiceRegistryEndpointTests.MYSTATUS;
        }

        public AtomicReference<String> getUpdatedStatus() {
            return this.updatedStatus;
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    public static class TestConfiguration {
        @Bean
        Registration registration() {
            return new Registration(){

                public String getServiceId() {
                    return "testRegistration1";
                }

                public String getHost() {
                    return null;
                }

                public int getPort() {
                    return 0;
                }

                public boolean isSecure() {
                    return false;
                }

                public URI getUri() {
                    return null;
                }

                public Map<String, String> getMetadata() {
                    return null;
                }
            };
        }

        @Bean
        ServiceRegistry serviceRegistry() {
            return new TestServiceRegistry();
        }
    }
}

