/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.config.Lookup;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultApacheHttpClientConnectionManagerFactoryTests {
    @Test
    public void newConnectionManager() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6);
        Assert.assertEquals((long)6L, (long)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute());
        Assert.assertEquals((long)2L, (long)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal());
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        Assert.assertEquals((Object)new Long(-1L), this.getField(pool, "timeToLive"));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)timeUnit));
    }

    @Test
    public void newConnectionManagerWithTTL() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6, 56L, TimeUnit.DAYS, null);
        Assert.assertEquals((long)6L, (long)((PoolingHttpClientConnectionManager)connectionManager).getDefaultMaxPerRoute());
        Assert.assertEquals((long)2L, (long)((PoolingHttpClientConnectionManager)connectionManager).getMaxTotal());
        Object pool = this.getField((PoolingHttpClientConnectionManager)connectionManager, "pool");
        Assert.assertEquals((Object)new Long(56L), this.getField(pool, "timeToLive"));
        TimeUnit timeUnit = (TimeUnit)((Object)this.getField(pool, "tunit"));
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)timeUnit));
    }

    @Test
    public void newConnectionManagerWithSSL() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(false, 2, 6);
        Lookup<ConnectionSocketFactory> socketFactoryRegistry = this.getConnectionSocketFactoryLookup(connectionManager);
        Assert.assertThat((Object)socketFactoryRegistry.lookup("https"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getX509TrustManager(socketFactoryRegistry).getAcceptedIssuers(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void newConnectionManagerWithDisabledSSLValidation() throws Exception {
        HttpClientConnectionManager connectionManager = new DefaultApacheHttpClientConnectionManagerFactory().newConnectionManager(true, 2, 6);
        Lookup<ConnectionSocketFactory> socketFactoryRegistry = this.getConnectionSocketFactoryLookup(connectionManager);
        Assert.assertThat((Object)socketFactoryRegistry.lookup("https"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)this.getX509TrustManager(socketFactoryRegistry).getAcceptedIssuers(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private Lookup<ConnectionSocketFactory> getConnectionSocketFactoryLookup(HttpClientConnectionManager connectionManager) {
        DefaultHttpClientConnectionOperator connectionOperator = (DefaultHttpClientConnectionOperator)this.getField(connectionManager, "connectionOperator");
        return (Lookup)this.getField(connectionOperator, "socketFactoryRegistry");
    }

    private X509TrustManager getX509TrustManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry) {
        ConnectionSocketFactory connectionSocketFactory = (ConnectionSocketFactory)socketFactoryRegistry.lookup("https");
        SSLSocketFactory sslSocketFactory = (SSLSocketFactory)this.getField(connectionSocketFactory, "socketfactory");
        SSLContextSpi sslContext = (SSLContextSpi)this.getField(sslSocketFactory, "context");
        return (X509TrustManager)this.getField(sslContext, "trustManager");
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

