/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBean(value={LoadBalancerClient.class})
@AutoConfigureAfter(value={ReactorLoadBalancerClientAutoConfiguration.class})
@ConditionalOnMissingBean(value={ReactorLoadBalancerExchangeFilterFunction.class})
@Deprecated
public class ReactiveLoadBalancerAutoConfiguration {
    @LoadBalanced
    @Autowired(required=false)
    private List<WebClient.Builder> webClientBuilders = Collections.emptyList();

    public List<WebClient.Builder> getBuilders() {
        return this.webClientBuilders;
    }

    @Bean
    public SmartInitializingSingleton loadBalancedWebClientInitializer(List<WebClientCustomizer> customizers) {
        return () -> {
            for (WebClient.Builder webClientBuilder : this.getBuilders()) {
                for (WebClientCustomizer customizer : customizers) {
                    customizer.customize(webClientBuilder);
                }
            }
        };
    }

    @Bean
    public WebClientCustomizer loadBalancerClientWebClientCustomizer(LoadBalancerExchangeFilterFunction filterFunction) {
        return builder -> builder.filter((ExchangeFilterFunction)filterFunction);
    }

    @Bean
    public LoadBalancerExchangeFilterFunction loadBalancerExchangeFilterFunction(LoadBalancerClient client) {
        return new LoadBalancerExchangeFilterFunction(client);
    }
}

