/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClientTestsConfig;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.cloud.discovery.client.simple.order:2"}, classes={CompositeDiscoveryClientTestsConfig.class})
public class CompositeDiscoveryClientOrderTest {
    @Autowired
    DiscoveryClient discoveryClient;

    @Test
    public void shouldGetOrderedDiscoveryClients() {
        List discoveryClients = ((CompositeDiscoveryClient)this.discoveryClient).getDiscoveryClients();
        BDDAssertions.then((String)((DiscoveryClient)discoveryClients.get(0)).description()).isEqualTo("A custom discovery client");
        BDDAssertions.then((String)((DiscoveryClient)discoveryClients.get(1)).description()).isEqualTo("Default order discovery client");
        BDDAssertions.then((String)((DiscoveryClient)discoveryClients.get(2)).description()).isEqualTo("Simple Discovery Client");
        BDDAssertions.then((String)((DiscoveryClient)discoveryClients.get(3)).description()).isEqualTo("Fourth discovery client");
    }

    @Test
    public void shouldOnlyReturnServiceInstancesForTheHighestPrecedenceDiscoveryClient() {
        List serviceInstances = this.discoveryClient.getInstances("custom");
        BDDAssertions.then((List)serviceInstances).hasSize(1);
        BDDAssertions.then((int)((ServiceInstance)serviceInstances.get(0)).getPort()).isEqualTo(123);
    }
}

