/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClientTestsConfig;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.application.name=service0", "spring.cloud.discovery.client.simple.instances.service1[0].uri=http://s11:8080", "spring.cloud.discovery.client.simple.instances.service1[1].uri=https://s12:8443", "spring.cloud.discovery.client.simple.instances.service2[0].uri=https://s21:8080", "spring.cloud.discovery.client.simple.instances.service2[1].uri=https://s22:443"}, classes={CompositeDiscoveryClientTestsConfig.class})
public class CompositeDiscoveryClientTests {
    @Autowired
    private DiscoveryClient discoveryClient;

    @Test
    public void getInstancesByServiceIdShouldDelegateCall() {
        BDDAssertions.then((Object)this.discoveryClient).isInstanceOf(CompositeDiscoveryClient.class);
        BDDAssertions.then((List)this.discoveryClient.getInstances("service1")).hasSize(2);
        ServiceInstance s1 = (ServiceInstance)this.discoveryClient.getInstances("service1").get(0);
        BDDAssertions.then((String)s1.getHost()).isEqualTo("s11");
        BDDAssertions.then((int)s1.getPort()).isEqualTo(8080);
        BDDAssertions.then((URI)s1.getUri()).isEqualTo((Object)URI.create("http://s11:8080"));
        BDDAssertions.then((boolean)s1.isSecure()).isEqualTo(false);
    }

    @Test
    public void getServicesShouldAggregateAllServiceNames() {
        BDDAssertions.then((List)this.discoveryClient.getServices()).containsOnlyOnce((Object[])new String[]{"service1", "service2", "custom"});
    }

    @Test
    public void getDescriptionShouldBeComposite() {
        BDDAssertions.then((String)this.discoveryClient.description()).isEqualTo("Composite Discovery Client");
    }

    @Test
    public void getInstancesShouldRespectOrder() {
        BDDAssertions.then((List)this.discoveryClient.getInstances("custom")).hasSize(1);
        BDDAssertions.then((List)this.discoveryClient.getInstances("custom")).hasSize(1);
    }

    @Test
    public void getInstancesByUnknownServiceIdShouldReturnAnEmptyList() {
        BDDAssertions.then((List)this.discoveryClient.getInstances("unknown")).hasSize(0);
    }
}

