/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.composite.reactive;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;
import reactor.test.publisher.TestPublisher;

@ExtendWith(value={MockitoExtension.class})
class ReactiveCompositeDiscoveryClientTests {
    @Mock
    private ReactiveDiscoveryClient discoveryClient1;
    @Mock
    private ReactiveDiscoveryClient discoveryClient2;

    ReactiveCompositeDiscoveryClientTests() {
    }

    @Test
    public void shouldReturnEmptyFluxOfServices() {
        ReactiveCompositeDiscoveryClient client = new ReactiveCompositeDiscoveryClient(Collections.emptyList());
        Flux services = client.getServices();
        StepVerifier.create((Publisher)services).expectComplete().verify();
    }

    @Test
    public void shouldReturnFluxOfServices() {
        TestPublisher discoveryClient1Publisher = TestPublisher.createCold();
        discoveryClient1Publisher.emit((Object[])new String[]{"serviceAFromClient1"});
        discoveryClient1Publisher.emit((Object[])new String[]{"serviceBFromClient1"});
        discoveryClient1Publisher.complete();
        TestPublisher discoveryClient2Publisher = TestPublisher.createCold();
        discoveryClient2Publisher.emit((Object[])new String[]{"serviceCFromClient2"});
        discoveryClient2Publisher.complete();
        Mockito.when((Object)this.discoveryClient1.getServices()).thenReturn((Object)discoveryClient1Publisher.flux());
        Mockito.when((Object)this.discoveryClient2.getServices()).thenReturn((Object)discoveryClient2Publisher.flux());
        ReactiveCompositeDiscoveryClient client = new ReactiveCompositeDiscoveryClient(Arrays.asList(this.discoveryClient1, this.discoveryClient2));
        Assertions.assertThat((String)client.description()).isEqualTo("Composite Reactive Discovery Client");
        Flux services = client.getServices();
        StepVerifier.create((Publisher)services).expectNext((Object)"serviceAFromClient1").expectNext((Object)"serviceBFromClient1").expectNext((Object)"serviceCFromClient2").expectComplete().verify();
    }

    @Test
    public void shouldReturnEmptyFluxOfServiceInstances() {
        ReactiveCompositeDiscoveryClient client = new ReactiveCompositeDiscoveryClient(Collections.emptyList());
        Flux instances = client.getInstances("service");
        StepVerifier.create((Publisher)instances).expectComplete().verify();
    }

    @Test
    public void shouldReturnFluxOfServiceInstances() {
        DefaultServiceInstance serviceInstance1 = new DefaultServiceInstance("instance", "service", "localhost", 8080, false);
        DefaultServiceInstance serviceInstance2 = new DefaultServiceInstance("instance2", "service", "localhost", 8080, false);
        TestPublisher discoveryClient1Publisher = TestPublisher.createCold();
        discoveryClient1Publisher.emit((Object[])new ServiceInstance[]{serviceInstance1});
        discoveryClient1Publisher.emit((Object[])new ServiceInstance[]{serviceInstance2});
        discoveryClient1Publisher.complete();
        TestPublisher discoveryClient2Publisher = TestPublisher.createCold();
        discoveryClient2Publisher.complete();
        Mockito.when((Object)this.discoveryClient1.getInstances("service")).thenReturn((Object)discoveryClient1Publisher.flux());
        Mockito.when((Object)this.discoveryClient2.getInstances("service")).thenReturn((Object)discoveryClient2Publisher.flux());
        ReactiveCompositeDiscoveryClient client = new ReactiveCompositeDiscoveryClient(Arrays.asList(this.discoveryClient1, this.discoveryClient2));
        Flux instances = client.getInstances("service");
        StepVerifier.create((Publisher)instances).expectNext((Object)serviceInstance1).expectNext((Object)serviceInstance2).expectComplete().verify();
    }
}

