/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.Arrays;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class, CommonsClientAutoConfiguration.class}, properties={"spring.cloud.discovery.client.health-indicator.include-description:true"})
public class DiscoveryClientHealthIndicatorTests {
    @Autowired
    private DiscoveryCompositeHealthContributor healthContributor;
    @Autowired
    private DiscoveryClientHealthIndicator clientHealthIndicator;

    @Test
    public void testHealthIndicatorDescriptionDisabled() {
        ((IterableAssert)BDDAssertions.then((Iterable)this.healthContributor).as("healthIndicator was null", new Object[0])).isNotNull();
        this.assertHealth(this.getHealth("testDiscoveryHealthIndicator"), Status.UNKNOWN);
        this.assertHealth(this.getHealth("discoveryClient"), Status.UNKNOWN);
        this.clientHealthIndicator.onApplicationEvent(new InstanceRegisteredEvent((Object)this, null));
        this.assertHealth(this.getHealth("testDiscoveryHealthIndicator"), Status.UNKNOWN);
        Status status = this.assertHealth(this.getHealth("discoveryClient"), Status.UP);
        ((AbstractStringAssert)BDDAssertions.then((String)status.getDescription()).as("status description was wrong", new Object[0])).isEqualTo("TestDiscoveryClient");
    }

    private Health getHealth(String name) {
        HealthContributor delegate = (HealthContributor)this.healthContributor.getContributor(name);
        return ((HealthIndicator)delegate).health();
    }

    private Status assertHealth(Health health, Status expected) {
        ((ObjectAssert)BDDAssertions.then((Object)health).as("health was null", new Object[0])).isNotNull();
        Status status = health.getStatus();
        ((ObjectAssert)BDDAssertions.then((Object)status).as("status was null", new Object[0])).isNotNull();
        BDDAssertions.then((String)status.getCode()).isEqualTo(expected.getCode()).as("status code was wrong", new Object[0]);
        return status;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties
    public static class Config {
        @Bean
        public DiscoveryClient discoveryClient() {
            DiscoveryClient mock = (DiscoveryClient)Mockito.mock(DiscoveryClient.class);
            BDDMockito.given((Object)mock.description()).willReturn((Object)"TestDiscoveryClient");
            BDDMockito.given((Object)mock.getServices()).willReturn(Arrays.asList("TestService1"));
            return mock;
        }

        @Bean
        public DiscoveryHealthIndicator discoveryHealthIndicator() {
            return new DiscoveryHealthIndicator(){

                public String getName() {
                    return "testDiscoveryHealthIndicator";
                }

                public Health health() {
                    return new Health.Builder().unknown().build();
                }
            };
        }
    }
}

