/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health.reactive;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

@ExtendWith(value={MockitoExtension.class})
class ReactiveDiscoveryClientHealthIndicatorTests {
    @Mock
    private ReactiveDiscoveryClient discoveryClient;
    @Mock
    private DiscoveryClientHealthIndicatorProperties properties;
    @InjectMocks
    private ReactiveDiscoveryClientHealthIndicator indicator;

    ReactiveDiscoveryClientHealthIndicatorTests() {
    }

    @Test
    public void shouldReturnCorrectOrder() {
        Assertions.assertThat((int)this.indicator.getOrder()).isEqualTo(Integer.MIN_VALUE);
        this.indicator.setOrder(0);
        Assertions.assertThat((int)this.indicator.getOrder()).isEqualTo(0);
    }

    @Test
    public void shouldReturnUnknownStatusWhenNotInitialized() {
        Health expectedHealth = Health.status((Status)new Status(Status.UNKNOWN.getCode(), "Discovery Client not initialized")).build();
        Mono health = this.indicator.health();
        StepVerifier.create((Publisher)health).expectNext((Object)expectedHealth).expectComplete().verify();
    }

    @Test
    public void shouldReturnUpStatusWithoutServices() {
        Mockito.when((Object)this.discoveryClient.description()).thenReturn((Object)"Mocked Service Discovery Client");
        Mockito.when((Object)this.discoveryClient.getServices()).thenReturn((Object)Flux.empty());
        Health expectedHealth = Health.status((Status)new Status(Status.UP.getCode(), "")).withDetail("services", Collections.emptyList()).build();
        this.indicator.onApplicationEvent(new InstanceRegisteredEvent((Object)this, null));
        Mono health = this.indicator.health();
        Assertions.assertThat((String)this.indicator.getName()).isEqualTo("Mocked Service Discovery Client");
        StepVerifier.create((Publisher)health).expectNext((Object)expectedHealth).expectComplete().verify();
    }

    @Test
    public void shouldReturnUpStatusWithServices() {
        Mockito.when((Object)this.discoveryClient.getServices()).thenReturn((Object)Flux.just((Object)"service"));
        Mockito.when((Object)this.properties.isIncludeDescription()).thenReturn((Object)true);
        Mockito.when((Object)this.discoveryClient.description()).thenReturn((Object)"Mocked Service Discovery Client");
        Health expectedHealth = Health.status((Status)new Status(Status.UP.getCode(), "Mocked Service Discovery Client")).withDetail("services", Collections.singletonList("service")).build();
        this.indicator.onApplicationEvent(new InstanceRegisteredEvent((Object)this, null));
        Mono health = this.indicator.health();
        Assertions.assertThat((String)this.indicator.getName()).isEqualTo("Mocked Service Discovery Client");
        StepVerifier.create((Publisher)health).expectNext((Object)expectedHealth).expectComplete().verify();
    }

    @Test
    public void shouldReturnDownStatusWhenServicesCouldNotBeRetrieved() {
        RuntimeException ex = new RuntimeException("something went wrong");
        Health expectedHealth = Health.down((Exception)ex).build();
        Mockito.when((Object)this.discoveryClient.getServices()).thenReturn((Object)Flux.error((Throwable)ex));
        this.indicator.onApplicationEvent(new InstanceRegisteredEvent((Object)this, null));
        Mono health = this.indicator.health();
        StepVerifier.create((Publisher)health).expectNext((Object)expectedHealth).expectComplete().verifyThenAssertThat();
    }
}

