/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import java.util.List;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(properties={"spring.application.name=service0", "spring.cloud.discovery.client.simple.instances.service1[0].uri=http://s11:8080", "spring.cloud.discovery.client.simple.instances.service1[1].uri=https://s12:8443", "spring.cloud.discovery.client.simple.instances.service2[0].uri=https://s21:8080", "spring.cloud.discovery.client.simple.instances.service2[1].uri=https://s22:443"})
public class SimpleDiscoveryClientPropertiesMappingTests {
    @Autowired
    private SimpleDiscoveryProperties props;
    @Autowired
    private SimpleDiscoveryClient discoveryClient;

    @Test
    public void propsShouldGetCleanlyMapped() {
        BDDAssertions.then((int)this.props.getInstances().size()).isEqualTo(2);
        BDDAssertions.then((int)((List)this.props.getInstances().get("service1")).size()).isEqualTo(2);
        BDDAssertions.then((String)((DefaultServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getHost()).isEqualTo("s11");
        BDDAssertions.then((int)((DefaultServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getPort()).isEqualTo(8080);
        BDDAssertions.then((URI)((DefaultServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).getUri()).isEqualTo((Object)URI.create("http://s11:8080"));
        BDDAssertions.then((boolean)((DefaultServiceInstance)((List)this.props.getInstances().get("service1")).get(0)).isSecure()).isEqualTo(false);
        BDDAssertions.then((int)((List)this.props.getInstances().get("service2")).size()).isEqualTo(2);
        BDDAssertions.then((String)((DefaultServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getHost()).isEqualTo("s21");
        BDDAssertions.then((int)((DefaultServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getPort()).isEqualTo(8080);
        BDDAssertions.then((URI)((DefaultServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).getUri()).isEqualTo((Object)URI.create("https://s21:8080"));
        BDDAssertions.then((boolean)((DefaultServiceInstance)((List)this.props.getInstances().get("service2")).get(0)).isSecure()).isEqualTo(true);
    }

    @Test
    public void testDiscoveryClientShouldResolveSimpleValues() {
        BDDAssertions.then((String)this.discoveryClient.description()).isEqualTo("Simple Discovery Client");
        BDDAssertions.then((List)this.discoveryClient.getInstances("service1")).hasSize(2);
        ServiceInstance s1 = (ServiceInstance)this.discoveryClient.getInstances("service1").get(0);
        BDDAssertions.then((String)s1.getHost()).isEqualTo("s11");
        BDDAssertions.then((int)s1.getPort()).isEqualTo(8080);
        BDDAssertions.then((URI)s1.getUri()).isEqualTo((Object)URI.create("http://s11:8080"));
        BDDAssertions.then((boolean)s1.isSecure()).isEqualTo(false);
    }

    @Test
    public void testGetServices() {
        BDDAssertions.then((List)this.discoveryClient.getServices()).containsExactlyInAnyOrder((Object[])new String[]{"service1", "service2"});
    }

    @Test
    public void testGetANonExistentServiceShouldReturnAnEmptyList() {
        BDDAssertions.then((List)this.discoveryClient.getInstances("nonexistent")).isNotNull();
        BDDAssertions.then((List)this.discoveryClient.getInstances("nonexistent")).isEmpty();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class SampleConfig {
    }
}

