/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;

class SimpleReactiveDiscoveryClientAutoConfigurationTests {
    private ApplicationContextRunner contextRunner = (ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{SimpleReactiveDiscoveryClientAutoConfiguration.class, UtilAutoConfiguration.class}));

    SimpleReactiveDiscoveryClientAutoConfigurationTests() {
    }

    @Test
    public void shouldUseDefaults() {
        this.contextRunner.run(context -> {
            ReactiveDiscoveryClient client = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            Assertions.assertThat((Object)client).isNotNull();
            Assertions.assertThat((int)client.getOrder()).isEqualTo(0);
            InetUtils inet = (InetUtils)context.getBean(InetUtils.class);
            Assertions.assertThat((Object)inet).isNotNull();
            SimpleReactiveDiscoveryProperties properties = (SimpleReactiveDiscoveryProperties)context.getBean(SimpleReactiveDiscoveryProperties.class);
            Assertions.assertThat((Object)properties).isNotNull();
            Assertions.assertThat((String)properties.getLocal().getServiceId()).isEqualTo("application");
            Assertions.assertThat((String)properties.getLocal().getHost()).isEqualTo(inet.findFirstNonLoopbackHostInfo().getHostname());
            Assertions.assertThat((int)properties.getLocal().getPort()).isEqualTo(8080);
        });
    }

    @Test
    public void shouldUseCustomConfiguration() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withUserConfiguration(new Class[]{Configuration.class})).withPropertyValues(new String[]{"spring.application.name=my-service", "spring.cloud.discovery.client.simple.order=1", "server.port=8443"})).run(context -> {
            ReactiveDiscoveryClient client = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            Assertions.assertThat((Object)client).isNotNull();
            Assertions.assertThat((int)client.getOrder()).isEqualTo(1);
            InetUtils inet = (InetUtils)context.getBean(InetUtils.class);
            Assertions.assertThat((Object)inet).isNotNull();
            SimpleReactiveDiscoveryProperties properties = (SimpleReactiveDiscoveryProperties)context.getBean(SimpleReactiveDiscoveryProperties.class);
            Assertions.assertThat((Object)properties).isNotNull();
            Assertions.assertThat((String)properties.getLocal().getServiceId()).isEqualTo("my-service");
            Assertions.assertThat((String)properties.getLocal().getHost()).isEqualTo(inet.findFirstNonLoopbackHostInfo().getHostname());
            Assertions.assertThat((int)properties.getLocal().getPort()).isEqualTo(8443);
        });
    }

    @TestConfiguration
    @EnableConfigurationProperties(value={ServerProperties.class})
    static class Configuration {
        Configuration() {
        }
    }
}

