/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryProperties;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class SimpleReactiveDiscoveryClientTests {
    private final DefaultServiceInstance service1Inst1 = new DefaultServiceInstance(null, null, "host1", 8080, false);
    private final DefaultServiceInstance service1Inst2 = new DefaultServiceInstance(null, null, "host2", 8443, true);
    private SimpleReactiveDiscoveryClient client;

    @BeforeEach
    public void setUp() {
        SimpleReactiveDiscoveryProperties simpleReactiveDiscoveryProperties = new SimpleReactiveDiscoveryProperties();
        simpleReactiveDiscoveryProperties.setInstances(Collections.singletonMap("service", Arrays.asList(this.service1Inst1, this.service1Inst2)));
        simpleReactiveDiscoveryProperties.init();
        this.client = new SimpleReactiveDiscoveryClient(simpleReactiveDiscoveryProperties);
    }

    @Test
    public void verifyDefaults() {
        Assertions.assertThat((String)this.client.description()).isEqualTo("Simple Reactive Discovery Client");
        Assertions.assertThat((int)this.client.getOrder()).isEqualTo(0);
    }

    @Test
    public void shouldReturnFluxOfServices() {
        Flux services = this.client.getServices();
        StepVerifier.create((Publisher)services).expectNext((Object)"service").expectComplete().verify();
    }

    @Test
    public void shouldReturnEmptyFluxForNonExistingService() {
        Flux instances = this.client.getInstances("undefined");
        StepVerifier.create((Publisher)instances).expectComplete();
    }

    @Test
    public void shouldReturnFluxOfServiceInstances() {
        Flux services = this.client.getInstances("service");
        StepVerifier.create((Publisher)services).expectNext((Object)this.service1Inst1).expectNext((Object)this.service1Inst2).expectComplete().verify();
    }
}

