/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractLoadBalancerAutoConfigurationTests {
    @Test
    public void restTemplateGetsLoadBalancerInterceptor() {
        ConfigurableApplicationContext context = this.init(OneRestTemplate.class);
        Map restTemplates = context.getBeansOfType(RestTemplate.class);
        BDDAssertions.then((Map)restTemplates).isNotNull();
        BDDAssertions.then(restTemplates.values()).hasSize(1);
        RestTemplate restTemplate = (RestTemplate)restTemplates.values().iterator().next();
        BDDAssertions.then((Object)restTemplate).isNotNull();
        this.assertLoadBalanced(restTemplate);
    }

    protected abstract void assertLoadBalanced(RestTemplate var1);

    @Test
    public void multipleRestTemplates() {
        ConfigurableApplicationContext context = this.init(TwoRestTemplates.class);
        Map restTemplates = context.getBeansOfType(RestTemplate.class);
        BDDAssertions.then((Map)restTemplates).isNotNull();
        Collection templates = restTemplates.values();
        BDDAssertions.then(templates).hasSize(2);
        TwoRestTemplates.Two two = (TwoRestTemplates.Two)context.getBean(TwoRestTemplates.Two.class);
        BDDAssertions.then((Object)two.loadBalanced).isNotNull();
        this.assertLoadBalanced(two.loadBalanced);
        BDDAssertions.then((Object)two.nonLoadBalanced).isNotNull();
        BDDAssertions.then((List)two.nonLoadBalanced.getInterceptors()).isEmpty();
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        return this.init(config, "spring.aop.proxyTargetClass=true");
    }

    protected ConfigurableApplicationContext init(Class<?> config, String ... props) {
        return new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).properties(props).sources(new Class[]{config, LoadBalancerAutoConfiguration.class}).run(new String[0]);
    }

    private static class TestLoadBalancerFactory
    implements ReactiveLoadBalancer.Factory<ServiceInstance> {
        private TestLoadBalancerFactory() {
        }

        public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Object getInstance(String name, Class clazz, Class[] generics) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Map getInstances(String name, Class type) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    private static class NoopLoadBalancerClient
    implements LoadBalancerClient {
        private final Random random = new Random();

        private NoopLoadBalancerClient() {
        }

        public ServiceInstance choose(String serviceId) {
            return this.choose(serviceId, ReactiveLoadBalancer.REQUEST);
        }

        public <T> ServiceInstance choose(String serviceId, Request<T> request) {
            return new DefaultServiceInstance(serviceId, serviceId, serviceId, this.random.nextInt(40000), false);
        }

        public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
            try {
                return (T)request.apply(this.choose(serviceId, ReactiveLoadBalancer.REQUEST));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) {
            try {
                return (T)request.apply(this.choose(serviceId, ReactiveLoadBalancer.REQUEST));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public URI reconstructURI(ServiceInstance instance, URI original) {
            return DefaultServiceInstance.getUri((ServiceInstance)instance);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={OneRestTemplate.class})
    protected static class TwoRestTemplates {
        protected TwoRestTemplates() {
        }

        @Primary
        @Bean
        RestTemplate restTemplate() {
            return new RestTemplate();
        }

        @Configuration(proxyBeanMethods=false)
        protected static class Two {
            @Autowired
            RestTemplate nonLoadBalanced;
            @Autowired
            @LoadBalanced
            RestTemplate loadBalanced;

            protected Two() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class OneRestTemplate {
        protected OneRestTemplate() {
        }

        @LoadBalanced
        @Bean
        RestTemplate loadBalancedRestTemplate() {
            return new RestTemplate();
        }

        @Bean
        LoadBalancerClient loadBalancerClient() {
            return new NoopLoadBalancerClient();
        }

        @Bean
        ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory() {
            return new TestLoadBalancerFactory();
        }
    }
}

