/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.InterceptorRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.http.HttpRequest;
import org.springframework.retry.RetryContext;

@RunWith(value=MockitoJUnitRunner.class)
public class InterceptorRetryPolicyTest {
    private HttpRequest request;
    private LoadBalancedRetryPolicy policy;
    private ServiceInstanceChooser serviceInstanceChooser;
    private String serviceName;

    @Before
    public void setup() {
        this.request = (HttpRequest)Mockito.mock(HttpRequest.class);
        this.policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        this.serviceInstanceChooser = (ServiceInstanceChooser)Mockito.mock(ServiceInstanceChooser.class);
        this.serviceName = "foo";
    }

    @After
    public void teardown() {
        this.request = null;
        this.policy = null;
        this.serviceInstanceChooser = null;
        this.serviceName = null;
    }

    @Test
    public void canRetryBeforeExecution() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)0);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isTrue();
        ((LoadBalancedRetryContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).setServiceInstance((ServiceInstance)ArgumentMatchers.eq(null));
    }

    @Test
    public void canRetryNextServer() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)1);
        Mockito.when((Object)this.policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.eq((Object)context))).thenReturn((Object)true);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isTrue();
    }

    @Test
    public void cannotRetry() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Mockito.when((Object)context.getRetryCount()).thenReturn((Object)1);
        BDDAssertions.then((boolean)interceptorRetryPolicy.canRetry((RetryContext)context)).isFalse();
    }

    @Test
    public void open() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        RetryContext context = interceptorRetryPolicy.open(null);
        BDDAssertions.then((Object)context).isInstanceOf(LoadBalancedRetryContext.class);
    }

    @Test
    public void close() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        interceptorRetryPolicy.close((RetryContext)context);
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)1))).close((LoadBalancedRetryContext)ArgumentMatchers.eq((Object)context));
    }

    @Test
    public void registerThrowable() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        LoadBalancedRetryContext context = (LoadBalancedRetryContext)Mockito.mock(LoadBalancedRetryContext.class);
        Exception thrown = new Exception();
        interceptorRetryPolicy.registerThrowable((RetryContext)context, (Throwable)thrown);
        ((LoadBalancedRetryContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).registerThrowable((Throwable)ArgumentMatchers.eq((Object)thrown));
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)1))).registerThrowable((LoadBalancedRetryContext)ArgumentMatchers.eq((Object)context), (Throwable)ArgumentMatchers.eq((Object)thrown));
    }

    @Test
    public void equals() {
        InterceptorRetryPolicy interceptorRetryPolicy = new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName);
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals(null)).isFalse();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals(new Object())).isFalse();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals((Object)interceptorRetryPolicy)).isTrue();
        BDDAssertions.then((boolean)interceptorRetryPolicy.equals((Object)new InterceptorRetryPolicy(this.request, this.policy, this.serviceInstanceChooser, this.serviceName))).isTrue();
    }
}

