/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer;
import org.springframework.cloud.client.loadbalancer.ServiceRequestWrapper;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;

@RunWith(value=MockitoJUnitRunner.class)
public class LoadBalancerRequestFactoryConfigurationTests {
    @Mock
    private HttpRequest request;
    @Mock
    private HttpRequest transformedRequest;
    @Mock
    private HttpRequest transformedRequest2;
    @Mock
    private ClientHttpRequestExecution execution;
    @Mock
    private ServiceInstance instance;
    private byte[] body = new byte[0];
    private ArgumentCaptor<HttpRequest> httpRequestCaptor;
    private LoadBalancerRequestFactory lbReqFactory;
    private LoadBalancerRequest<?> lbRequest;

    @Before
    public void setup() {
        this.httpRequestCaptor = ArgumentCaptor.forClass(HttpRequest.class);
    }

    protected ConfigurableApplicationContext init(Class<?> config) {
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).properties(new String[]{"spring.aop.proxyTargetClass=true"}).sources(new Class[]{config, LoadBalancerAutoConfiguration.class}).run(new String[0]);
        this.lbReqFactory = (LoadBalancerRequestFactory)context.getBean(LoadBalancerRequestFactory.class);
        this.lbRequest = this.lbReqFactory.createRequest(this.request, this.body, this.execution);
        return context;
    }

    @Test
    public void transformer() throws Exception {
        ConfigurableApplicationContext context = this.init(Transformer.class);
        LoadBalancerRequestTransformer transformer = (LoadBalancerRequestTransformer)context.getBean("transformer", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer.transformRequest((HttpRequest)ArgumentMatchers.any(ServiceRequestWrapper.class), (ServiceInstance)ArgumentMatchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])ArgumentMatchers.eq((Object)this.body));
        ((ObjectAssert)BDDAssertions.then((Object)this.httpRequestCaptor.getValue()).as("transformer should have transformed the ServiceRequestWrapper into transformedRequest", new Object[0])).isEqualTo((Object)this.transformedRequest);
    }

    @Test
    public void noTransformer() throws Exception {
        this.init(NoTransformer.class);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])ArgumentMatchers.eq((Object)this.body));
        ((ClassAssert)BDDAssertions.then(((HttpRequest)this.httpRequestCaptor.getValue()).getClass()).as("ServiceRequestWrapper should be executed", new Object[0])).isEqualTo(ServiceRequestWrapper.class);
    }

    @Test
    public void transformersAreOrdered() throws Exception {
        ConfigurableApplicationContext context = this.init(TransformersAreOrdered.class);
        LoadBalancerRequestTransformer transformer = (LoadBalancerRequestTransformer)context.getBean("transformer", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer.transformRequest((HttpRequest)ArgumentMatchers.any(ServiceRequestWrapper.class), (ServiceInstance)ArgumentMatchers.eq((Object)this.instance))).thenReturn((Object)this.transformedRequest);
        LoadBalancerRequestTransformer transformer2 = (LoadBalancerRequestTransformer)context.getBean("transformer2", LoadBalancerRequestTransformer.class);
        Mockito.when((Object)transformer2.transformRequest(this.transformedRequest, this.instance)).thenReturn((Object)this.transformedRequest2);
        this.lbRequest.apply(this.instance);
        ((ClientHttpRequestExecution)Mockito.verify((Object)this.execution)).execute((HttpRequest)this.httpRequestCaptor.capture(), (byte[])ArgumentMatchers.eq((Object)this.body));
        ((ObjectAssert)BDDAssertions.then((Object)this.httpRequestCaptor.getValue()).as("transformer2 should run after transformer", new Object[0])).isEqualTo((Object)this.transformedRequest2);
    }

    @Configuration(proxyBeanMethods=false)
    static class NoTransformer {
        NoTransformer() {
        }

        @Bean
        public LoadBalancerClient loadBalancerClient() {
            return (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        }

        @Bean
        ReactiveLoadBalancer.Factory<ServiceInstance> factory() {
            return (ReactiveLoadBalancer.Factory)Mockito.mock(ReactiveLoadBalancer.Factory.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={Transformer.class})
    static class TransformersAreOrdered {
        TransformersAreOrdered() {
        }

        @Bean
        @Order(value=1)
        public LoadBalancerRequestTransformer transformer2() {
            return (LoadBalancerRequestTransformer)Mockito.mock(LoadBalancerRequestTransformer.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={NoTransformer.class})
    static class Transformer {
        Transformer() {
        }

        @Bean
        public LoadBalancerRequestTransformer transformer() {
            return (LoadBalancerRequestTransformer)Mockito.mock(LoadBalancerRequestTransformer.class);
        }
    }
}

