/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryPolicy;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycleValidator;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequestFactory;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.TerminatedRetryException;
import org.springframework.retry.backoff.BackOffContext;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.listener.RetryListenerSupport;

@RunWith(value=MockitoJUnitRunner.class)
public class RetryLoadBalancerInterceptorTests {
    private LoadBalancerClient client;
    private LoadBalancerRequestFactory lbRequestFactory;
    private final LoadBalancedRetryFactory loadBalancedRetryFactory = new LoadBalancedRetryFactory(){};
    private LoadBalancerProperties properties;
    private ReactiveLoadBalancer.Factory<ServiceInstance> lbFactory;

    @Before
    public void setUp() {
        this.client = (LoadBalancerClient)Mockito.mock(LoadBalancerClient.class);
        this.lbRequestFactory = (LoadBalancerRequestFactory)Mockito.mock(LoadBalancerRequestFactory.class);
        this.properties = new LoadBalancerProperties();
        this.lbFactory = (ReactiveLoadBalancer.Factory)Mockito.mock(ReactiveLoadBalancer.Factory.class);
    }

    @After
    public void tearDown() {
        this.client = null;
    }

    @Test(expected=IOException.class)
    public void interceptDisableRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()});
        this.properties.getRetry().setEnabled(false);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, this.loadBalancedRetryFactory, this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test(expected=IllegalStateException.class)
    public void interceptInvalidHost() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo_underscore"));
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, this.loadBalancedRetryFactory, this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
    }

    @Test
    public void interceptNeverRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, this.loadBalancedRetryFactory, this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptSuccess() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        InputStream notFoundStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)notFoundStream.read((byte[])ArgumentMatchers.any(byte[].class))).thenReturn((Object)-1);
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse(notFoundStream, HttpStatus.NOT_FOUND);
        MockClientHttpResponse clientHttpResponseOk = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(ArgumentMatchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class))).thenReturn((Object)clientHttpResponseNotFound).thenReturn((Object)clientHttpResponseOk);
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.nullable(LoadBalancerRequest.class));
        ((InputStream)Mockito.verify((Object)notFoundStream, (VerificationMode)Mockito.times((int)1))).close();
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponseOk);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
    }

    @Test
    public void interceptRetryFailOnStatusCode() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        ByteArrayInputStream notFoundStream = new ByteArrayInputStream("foo".getBytes());
        MockClientHttpResponse clientHttpResponseNotFound = new MockClientHttpResponse((InputStream)notFoundStream, HttpStatus.NOT_FOUND);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.retryableStatusCode(ArgumentMatchers.eq((int)HttpStatus.NOT_FOUND.value()))).thenReturn((Object)true);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any())).thenReturn((Object)clientHttpResponseNotFound);
        this.properties.getRetry().setEnabled(true);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy), this.lbFactory);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any());
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)1))).createRequest(request, body, execution);
        ((LoadBalancedRetryPolicy)Mockito.verify((Object)policy, (VerificationMode)Mockito.times((int)2))).canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class));
        byte[] content = new byte[1024];
        int length = rsp.getBody().read(content);
        BDDAssertions.then((int)length).isEqualTo("foo".getBytes().length);
        BDDAssertions.then((String)new String(content, 0, length)).isEqualTo("foo");
    }

    @Test
    public void interceptRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
    }

    @Test(expected=IOException.class)
    public void interceptFailedRetry() throws Exception {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://foo"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)false);
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"foo"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"foo"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        this.properties.getRetry().setEnabled(true);
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, body, execution);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory)).createRequest(request, body, execution);
    }

    private static ServiceInstance defaultServiceInstance() {
        return new DefaultServiceInstance("testInstance", "test", "testHost", 80, false);
    }

    @Test
    public void retryListenerTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://listener"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"listener"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"listener"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.properties.getRetry().setEnabled(true);
        MyRetryListener retryListener = new MyRetryListener();
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy, new RetryListener[]{retryListener}), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)ArgumentMatchers.eq((Object)"listener"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
        BDDAssertions.then((int)retryListener.getOnError()).isEqualTo(1);
    }

    @Test
    public void retryWithDefaultConstructorTest() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://default"));
        MockClientHttpResponse clientHttpResponse = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        Mockito.when((Object)policy.canRetryNextServer((LoadBalancedRetryContext)ArgumentMatchers.any(LoadBalancedRetryContext.class))).thenReturn((Object)true);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        ServiceInstance serviceInstance = (ServiceInstance)Mockito.mock(ServiceInstance.class);
        Mockito.when((Object)this.client.choose((String)ArgumentMatchers.eq((Object)"default"), (Request)ArgumentMatchers.any())).thenReturn((Object)serviceInstance);
        Mockito.when((Object)this.client.execute((String)ArgumentMatchers.eq((Object)"default"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class))).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)clientHttpResponse);
        this.properties.getRetry().setEnabled(true);
        Mockito.when((Object)this.lbRequestFactory.createRequest((HttpRequest)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (ClientHttpRequestExecution)ArgumentMatchers.any())).thenReturn(Mockito.mock(LoadBalancerRequest.class));
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy), this.lbFactory);
        byte[] body = new byte[]{};
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        ClientHttpResponse rsp = interceptor.intercept(request, body, execution);
        ((LoadBalancerClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).execute((String)ArgumentMatchers.eq((Object)"default"), (ServiceInstance)ArgumentMatchers.eq((Object)serviceInstance), (LoadBalancerRequest)ArgumentMatchers.any(LoadBalancerRequest.class));
        BDDAssertions.then((Object)rsp).isEqualTo((Object)clientHttpResponse);
        ((LoadBalancerRequestFactory)Mockito.verify((Object)this.lbRequestFactory, (VerificationMode)Mockito.times((int)2))).createRequest(request, body, execution);
        BDDAssertions.then((int)backOffPolicy.getBackoffAttempts()).isEqualTo(1);
    }

    @Test(expected=TerminatedRetryException.class)
    public void retryListenerTestNoRetry() throws Throwable {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://noRetry"));
        LoadBalancedRetryPolicy policy = (LoadBalancedRetryPolicy)Mockito.mock(LoadBalancedRetryPolicy.class);
        MyBackOffPolicy backOffPolicy = new MyBackOffPolicy();
        this.properties.getRetry().setEnabled(true);
        RetryListenerSupport myRetryListener = new RetryListenerSupport(){

            public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
                return false;
            }
        };
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor(this.client, this.properties, this.lbRequestFactory, (LoadBalancedRetryFactory)new MyLoadBalancedRetryFactory(policy, backOffPolicy, new RetryListener[]{myRetryListener}), this.lbFactory);
        ClientHttpRequestExecution execution = (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class);
        interceptor.intercept(request, new byte[0], execution);
    }

    @Test
    public void shouldNotDuplicateLifecycleCalls() throws IOException, URISyntaxException {
        HashMap<String, TestLoadBalancerLifecycle> lifecycleProcessors = new HashMap<String, TestLoadBalancerLifecycle>();
        lifecycleProcessors.put("testLifecycle", new TestLoadBalancerLifecycle());
        lifecycleProcessors.put("anotherLifecycle", new AnotherLoadBalancerLifecycle());
        Mockito.when((Object)this.lbFactory.getInstances("test", LoadBalancerLifecycle.class)).thenReturn(lifecycleProcessors);
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getURI()).thenReturn((Object)new URI("http://test"));
        TestLoadBalancerClient client = new TestLoadBalancerClient();
        RetryLoadBalancerInterceptor interceptor = new RetryLoadBalancerInterceptor((LoadBalancerClient)client, this.properties, this.lbRequestFactory, this.loadBalancedRetryFactory, this.lbFactory);
        interceptor.intercept(request, new byte[0], (ClientHttpRequestExecution)Mockito.mock(ClientHttpRequestExecution.class));
        Assertions.assertThat(((TestLoadBalancerLifecycle)lifecycleProcessors.get("testLifecycle")).getStartLog()).hasSize(1);
        Assertions.assertThat(((TestLoadBalancerLifecycle)lifecycleProcessors.get("testLifecycle")).getCompleteLog()).hasSize(0);
        Assertions.assertThat(((TestLoadBalancerLifecycle)lifecycleProcessors.get("anotherLifecycle")).getStartLog()).hasSize(1);
        Assertions.assertThat(((TestLoadBalancerLifecycle)lifecycleProcessors.get("anotherLifecycle")).getCompleteLog()).hasSize(0);
        Assertions.assertThat(((TestLoadBalancerLifecycle)client.getLifecycleProcessors().get("testLifecycle")).getStartLog()).hasSize(0);
        Assertions.assertThat(((TestLoadBalancerLifecycle)client.getLifecycleProcessors().get("testLifecycle")).getCompleteLog()).hasSize(1);
        Assertions.assertThat(((TestLoadBalancerLifecycle)client.getLifecycleProcessors().get("anotherLifecycle")).getStartLog()).hasSize(0);
        Assertions.assertThat(((TestLoadBalancerLifecycle)client.getLifecycleProcessors().get("anotherLifecycle")).getCompleteLog()).hasSize(1);
    }

    protected static class AnotherLoadBalancerLifecycle
    extends TestLoadBalancerLifecycle {
        protected AnotherLoadBalancerLifecycle() {
        }

        @Override
        protected String getName() {
            return this.getClass().getSimpleName();
        }
    }

    protected static class TestLoadBalancerLifecycle
    implements LoadBalancerLifecycle<Object, Object, ServiceInstance> {
        final ConcurrentHashMap<String, Request<Object>> startLog = new ConcurrentHashMap();
        final ConcurrentHashMap<String, CompletionContext<Object, ServiceInstance>> completeLog = new ConcurrentHashMap();

        protected TestLoadBalancerLifecycle() {
        }

        public boolean supports(Class requestContextClass, Class responseClass, Class serverTypeClass) {
            return DefaultRequestContext.class.isAssignableFrom(requestContextClass) && Object.class.isAssignableFrom(responseClass) && ServiceInstance.class.isAssignableFrom(serverTypeClass);
        }

        public void onStart(Request<Object> request) {
            this.startLog.put(this.getName() + UUID.randomUUID(), request);
        }

        public void onComplete(CompletionContext<Object, ServiceInstance> completionContext) {
            this.completeLog.put(this.getName() + UUID.randomUUID(), completionContext);
        }

        ConcurrentHashMap<String, Request<Object>> getStartLog() {
            return this.startLog;
        }

        ConcurrentHashMap<String, CompletionContext<Object, ServiceInstance>> getCompleteLog() {
            return this.completeLog;
        }

        protected String getName() {
            return this.getClass().getSimpleName();
        }
    }

    protected static class TestLoadBalancerClient
    implements LoadBalancerClient {
        private final Map<String, LoadBalancerLifecycle> lifecycleProcessors = new HashMap<String, LoadBalancerLifecycle>();

        TestLoadBalancerClient() {
            this.lifecycleProcessors.put("testLifecycle", new TestLoadBalancerLifecycle());
            this.lifecycleProcessors.put("anotherLifecycle", new AnotherLoadBalancerLifecycle());
        }

        public <T> T execute(String serviceId, LoadBalancerRequest<T> request) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) {
            Set supportedLoadBalancerProcessors = LoadBalancerLifecycleValidator.getSupportedLifecycleProcessors(this.lifecycleProcessors, DefaultRequestContext.class, Object.class, ServiceInstance.class);
            MockClientHttpResponse response = new MockClientHttpResponse(new byte[0], HttpStatus.OK);
            supportedLoadBalancerProcessors.forEach(lifecycle -> lifecycle.onComplete(new CompletionContext(CompletionContext.Status.SUCCESS, (Response)new DefaultResponse(RetryLoadBalancerInterceptorTests.defaultServiceInstance()))));
            return (T)response;
        }

        public URI reconstructURI(ServiceInstance instance, URI original) {
            throw new UnsupportedOperationException("Please, implement me.");
        }

        public ServiceInstance choose(String serviceId) {
            return RetryLoadBalancerInterceptorTests.defaultServiceInstance();
        }

        public <T> ServiceInstance choose(String serviceId, Request<T> request) {
            return RetryLoadBalancerInterceptorTests.defaultServiceInstance();
        }

        Map<String, LoadBalancerLifecycle> getLifecycleProcessors() {
            return this.lifecycleProcessors;
        }
    }

    static class MyRetryListener
    extends RetryListenerSupport {
        private int onError = 0;

        MyRetryListener() {
        }

        public <T, E extends Throwable> void onError(RetryContext retryContext, RetryCallback<T, E> retryCallback, Throwable throwable) {
            ++this.onError;
        }

        int getOnError() {
            return this.onError;
        }
    }

    static class MyBackOffPolicy
    implements BackOffPolicy {
        private int backoffAttempts = 0;

        MyBackOffPolicy() {
        }

        public BackOffContext start(RetryContext retryContext) {
            return new BackOffContext(){

                protected Object clone() throws CloneNotSupportedException {
                    return super.clone();
                }
            };
        }

        public void backOff(BackOffContext backOffContext) throws BackOffInterruptedException {
            ++this.backoffAttempts;
        }

        int getBackoffAttempts() {
            return this.backoffAttempts;
        }
    }

    static class MyLoadBalancedRetryFactory
    implements LoadBalancedRetryFactory {
        private final LoadBalancedRetryPolicy loadBalancedRetryPolicy;
        private BackOffPolicy backOffPolicy;
        private RetryListener[] retryListeners;

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy) {
            this.loadBalancedRetryPolicy = loadBalancedRetryPolicy;
        }

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy, BackOffPolicy backOffPolicy) {
            this(loadBalancedRetryPolicy);
            this.backOffPolicy = backOffPolicy;
        }

        MyLoadBalancedRetryFactory(LoadBalancedRetryPolicy loadBalancedRetryPolicy, BackOffPolicy backOffPolicy, RetryListener[] retryListeners) {
            this(loadBalancedRetryPolicy, backOffPolicy);
            this.retryListeners = retryListeners;
        }

        public LoadBalancedRetryPolicy createRetryPolicy(String service, ServiceInstanceChooser serviceInstanceChooser) {
            return this.loadBalancedRetryPolicy;
        }

        public BackOffPolicy createBackOffPolicy(String service) {
            if (this.backOffPolicy == null) {
                return new NoBackOffPolicy();
            }
            return this.backOffPolicy;
        }

        public RetryListener[] createRetryListeners(String service) {
            if (this.retryListeners == null) {
                return new RetryListener[0];
            }
            return this.retryListeners;
        }
    }
}

