/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

class TestServiceInstance
implements ServiceInstance {
    private URI uri;
    private String scheme = "http";
    private String host = "test.example";
    private int port = 8080;
    private boolean secure;
    private Map<String, String> metadata = new LinkedHashMap<String, String>();

    TestServiceInstance() {
    }

    TestServiceInstance withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    TestServiceInstance withPort(int port) {
        this.port = port;
        return this;
    }

    TestServiceInstance withSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getServiceId() {
        return "test-service";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.scheme;
    }
}

