/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.BDDAssertions;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.loadbalancer.reactive.DeferringLoadBalancerExchangeFilterFunction;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

final class LoadBalancerTestUtils {
    private LoadBalancerTestUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static ConfigurableApplicationContext init(Class<?> ... configClasses) {
        return new SpringApplicationBuilder(new Class[0]).web(WebApplicationType.NONE).sources((Class[])ArrayUtils.add((Object[])configClasses, WebClientAutoConfiguration.class)).run(new String[0]);
    }

    static List<ExchangeFilterFunction> getFilters(WebClient.Builder builder) {
        return (List)ReflectionTestUtils.getField((Object)builder, (String)"filters");
    }

    static void assertLoadBalanced(WebClient.Builder webClientBuilder, Class<?> exchangeFilterFunctionClass) {
        List<ExchangeFilterFunction> filters = LoadBalancerTestUtils.getFilters(webClientBuilder);
        BDDAssertions.then(filters).hasSize(1);
        BDDAssertions.then((Object)filters.get(0)).isInstanceOf(DeferringLoadBalancerExchangeFilterFunction.class);
        DeferringLoadBalancerExchangeFilterFunction interceptor = (DeferringLoadBalancerExchangeFilterFunction)filters.get(0);
        interceptor.tryResolveDelegate();
        BDDAssertions.then((Object)interceptor.getDelegate()).isInstanceOf(exchangeFilterFunctionClass);
    }

    static void assertLoadBalanced(WebClient webClient, Class<?> exchangeFilterFunctionClass) {
        LoadBalancerTestUtils.assertLoadBalanced((WebClient.Builder)ReflectionTestUtils.getField((Object)webClient, (String)"builder"), exchangeFilterFunctionClass);
    }
}

