/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.DefaultRequestContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.ResponseData;
import org.springframework.cloud.client.loadbalancer.reactive.DiscoveryClientBasedReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableExchangeFilterFunctionLoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
class RetryableLoadBalancerExchangeFilterFunctionIntegrationTests {
    @Autowired
    private RetryableLoadBalancerExchangeFilterFunction loadBalancerFunction;
    @Autowired
    private SimpleDiscoveryProperties properties;
    @Autowired
    private LoadBalancerProperties loadBalancerProperties;
    @Autowired
    private ReactiveLoadBalancer.Factory<ServiceInstance> factory;
    @LocalServerPort
    private int port;

    RetryableLoadBalancerExchangeFilterFunctionIntegrationTests() {
    }

    @BeforeEach
    void setUp() {
        DefaultServiceInstance instance = new DefaultServiceInstance();
        instance.setServiceId("testservice");
        instance.setUri(URI.create("http://localhost:" + this.port));
        DefaultServiceInstance instanceWithNoLifecycleProcessors = new DefaultServiceInstance();
        instanceWithNoLifecycleProcessors.setServiceId("serviceWithNoLifecycleProcessors");
        instanceWithNoLifecycleProcessors.setUri(URI.create("http://localhost:" + this.port));
        this.properties.getInstances().put("testservice", Collections.singletonList(instance));
        this.properties.getInstances().put("serviceWithNoLifecycleProcessors", Collections.singletonList(instanceWithNoLifecycleProcessors));
    }

    @Test
    void loadBalancerLifecycleCallbacksExecuted() {
        String callbackTestHint = "callbackTestHint";
        this.loadBalancerProperties.getHint().put("testservice", "callbackTestHint");
        String result = "callbackTestResult";
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://testservice").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/callback", new Object[0]).exchange().block();
        Collection<Request<Object>> lifecycleLogRequests = ((TestLoadBalancerLifecycle)this.factory.getInstances("testservice", LoadBalancerLifecycle.class).get("loadBalancerLifecycle")).getStartLog().values();
        Collection<CompletionContext<Object, ServiceInstance>> anotherLifecycleLogRequests = ((AnotherLoadBalancerLifecycle)this.factory.getInstances("testservice", LoadBalancerLifecycle.class).get("anotherLoadBalancerLifecycle")).getCompleteLog().values();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        Assertions.assertThat(lifecycleLogRequests).extracting(request -> ((DefaultRequestContext)request.getContext()).getHint()).contains((Object[])new String[]{"callbackTestHint"});
        Assertions.assertThat(anotherLifecycleLogRequests).extracting(completionContext -> ((ResponseData)completionContext.getClientResponse()).getRequestData().getHttpMethod()).contains((Object[])new HttpMethod[]{HttpMethod.GET});
    }

    @Test
    void correctResponseReturnedForExistingHostAndInstancePresent() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://testservice").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/hello", new Object[0]).exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        BDDAssertions.then((String)((String)clientResponse.bodyToMono(String.class).block())).isEqualTo("Hello World");
    }

    @Test
    void correctResponseReturnedAfterRetryingOnSameServiceInstance() {
        this.loadBalancerProperties.getRetry().setMaxRetriesOnSameServiceInstance(1);
        this.loadBalancerProperties.getRetry().getRetryableStatusCodes().add(500);
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://testservice").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/exception", new Object[0]).exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        BDDAssertions.then((String)((String)clientResponse.bodyToMono(String.class).block())).isEqualTo("Hello World!");
    }

    @Test
    void correctResponseReturnedAfterRetryingOnNextServiceInstanceWithBackoff() {
        this.loadBalancerProperties.getRetry().getBackoff().setEnabled(true);
        this.loadBalancerProperties.getRetry().setMaxRetriesOnSameServiceInstance(1);
        DefaultServiceInstance goodRetryTestInstance = new DefaultServiceInstance();
        goodRetryTestInstance.setServiceId("retrytest");
        goodRetryTestInstance.setUri(URI.create("http://localhost:" + this.port));
        DefaultServiceInstance badRetryTestInstance = new DefaultServiceInstance();
        badRetryTestInstance.setServiceId("retrytest");
        badRetryTestInstance.setUri(URI.create("http://localhost:8080"));
        this.properties.getInstances().put("retrytest", Arrays.asList(badRetryTestInstance, goodRetryTestInstance));
        this.loadBalancerProperties.getRetry().getRetryableStatusCodes().add(500);
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://retrytest").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/hello", new Object[0]).exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        BDDAssertions.then((String)((String)clientResponse.bodyToMono(String.class).block())).isEqualTo("Hello World");
        ClientResponse secondClientResponse = (ClientResponse)WebClient.builder().baseUrl("http://retrytest").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/hello", new Object[0]).exchange().block();
        BDDAssertions.then((Comparable)secondClientResponse.statusCode()).isEqualTo((Object)HttpStatus.OK);
        BDDAssertions.then((String)((String)secondClientResponse.bodyToMono(String.class).block())).isEqualTo("Hello World");
    }

    @Test
    void serviceUnavailableReturnedWhenNoInstancePresent() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http://xxx").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.SERVICE_UNAVAILABLE);
    }

    @Test
    @Disabled
    void badRequestReturnedForIncorrectHost() {
        ClientResponse clientResponse = (ClientResponse)WebClient.builder().baseUrl("http:///xxx").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().exchange().block();
        BDDAssertions.then((Comparable)clientResponse.statusCode()).isEqualTo((Object)HttpStatus.BAD_REQUEST);
    }

    @Test
    void exceptionNotThrownWhenFactoryReturnsNullLifecycleProcessorsMap() {
        Assertions.assertThatCode(() -> {
            ClientResponse cfr_ignored_0 = (ClientResponse)WebClient.builder().baseUrl("http://serviceWithNoLifecycleProcessors").filter((ExchangeFilterFunction)this.loadBalancerFunction).build().get().uri("/hello", new Object[0]).exchange().block();
        }).doesNotThrowAnyException();
    }

    protected static class AnotherLoadBalancerLifecycle
    extends TestLoadBalancerLifecycle {
        protected AnotherLoadBalancerLifecycle() {
        }

        @Override
        protected String getName() {
            return this.getClass().getSimpleName();
        }
    }

    protected static class TestLoadBalancerLifecycle
    implements LoadBalancerLifecycle<Object, Object, ServiceInstance> {
        Map<String, Request<Object>> startLog = new ConcurrentHashMap<String, Request<Object>>();
        Map<String, CompletionContext<Object, ServiceInstance>> completeLog = new ConcurrentHashMap<String, CompletionContext<Object, ServiceInstance>>();

        protected TestLoadBalancerLifecycle() {
        }

        public void onStart(Request<Object> request) {
            this.startLog.put(this.getName() + UUID.randomUUID(), request);
        }

        public void onComplete(CompletionContext<Object, ServiceInstance> completionContext) {
            this.completeLog.clear();
            this.completeLog.put(this.getName() + UUID.randomUUID(), completionContext);
        }

        Map<String, Request<Object>> getStartLog() {
            return this.startLog;
        }

        Map<String, CompletionContext<Object, ServiceInstance>> getCompleteLog() {
            return this.completeLog;
        }

        protected String getName() {
            return this.getClass().getSimpleName();
        }
    }

    @EnableDiscoveryClient
    @EnableAutoConfiguration
    @SpringBootConfiguration(proxyBeanMethods=false)
    @RestController
    static class Config {
        AtomicInteger exceptionCallsCount = new AtomicInteger();

        Config() {
        }

        @GetMapping(value={"/hello"})
        public String hello() {
            return "Hello World";
        }

        @GetMapping(value={"/callback"})
        String callbackTestResult() {
            return "callbackTestResult";
        }

        @GetMapping(value={"/exception"})
        String exception() {
            int callCount = this.exceptionCallsCount.incrementAndGet();
            if (callCount % 2 != 0) {
                throw new IllegalStateException("Test!");
            }
            return "Hello World!";
        }

        @Bean
        ReactiveLoadBalancer.Factory<ServiceInstance> reactiveLoadBalancerFactory(final DiscoveryClient discoveryClient) {
            return new ReactiveLoadBalancer.Factory<ServiceInstance>(){
                private final TestLoadBalancerLifecycle testLoadBalancerLifecycle = new TestLoadBalancerLifecycle();
                private final TestLoadBalancerLifecycle anotherLoadBalancerLifecycle = new AnotherLoadBalancerLifecycle();

                public ReactiveLoadBalancer<ServiceInstance> getInstance(String serviceId) {
                    return new DiscoveryClientBasedReactiveLoadBalancer(serviceId, discoveryClient);
                }

                public <X> Map<String, X> getInstances(String name, Class<X> type) {
                    if (name.equals("serviceWithNoLifecycleProcessors")) {
                        return null;
                    }
                    HashMap<String, TestLoadBalancerLifecycle> lifecycleProcessors = new HashMap<String, TestLoadBalancerLifecycle>();
                    lifecycleProcessors.put("loadBalancerLifecycle", this.testLoadBalancerLifecycle);
                    lifecycleProcessors.put("anotherLoadBalancerLifecycle", this.anotherLoadBalancerLifecycle);
                    return lifecycleProcessors;
                }

                public <X> X getInstance(String name, Class<?> clazz, Class<?> ... generics) {
                    return null;
                }
            };
        }

        @Bean
        LoadBalancerProperties loadBalancerProperties() {
            return new LoadBalancerProperties();
        }

        @Bean
        RetryableLoadBalancerExchangeFilterFunction exchangeFilterFunction(LoadBalancerProperties properties, ReactiveLoadBalancer.Factory<ServiceInstance> factory) {
            return new RetryableLoadBalancerExchangeFilterFunction((LoadBalancerRetryPolicy)new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(properties), factory, properties);
        }
    }
}

