/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.io.IOException;
import java.net.URI;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableExchangeFilterFunctionLoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.TestReactiveLoadBalancer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

class RetryableLoadBalancerExchangeFilterFunctionTests {
    private final LoadBalancerProperties properties = new LoadBalancerProperties();
    private final LoadBalancerRetryPolicy policy = new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(this.properties);
    private final ReactiveLoadBalancer.Factory<ServiceInstance> factory = (ReactiveLoadBalancer.Factory)Mockito.mock(ReactiveLoadBalancer.Factory.class);
    private final RetryableLoadBalancerExchangeFilterFunction filterFunction = new RetryableLoadBalancerExchangeFilterFunction(this.policy, this.factory, this.properties);
    private final ClientRequest clientRequest = (ClientRequest)Mockito.mock(ClientRequest.class);
    private final ExchangeFunction next = (ExchangeFunction)Mockito.mock(ExchangeFunction.class);
    private final ClientResponse clientResponse = (ClientResponse)Mockito.mock(ClientResponse.class);
    private final InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.next, this.factory});

    RetryableLoadBalancerExchangeFilterFunctionTests() {
    }

    @BeforeEach
    void setUp() {
        this.properties.getRetry().setMaxRetriesOnSameServiceInstance(1);
        this.properties.getRetry().getRetryableStatusCodes().add(404);
        Mockito.when((Object)this.clientRequest.url()).thenReturn((Object)URI.create("http://test"));
        Mockito.when((Object)this.factory.getInstance("test")).thenReturn((Object)new TestReactiveLoadBalancer());
        Mockito.when((Object)this.clientRequest.headers()).thenReturn((Object)new HttpHeaders());
        Mockito.when((Object)this.clientRequest.cookies()).thenReturn((Object)new HttpHeaders());
    }

    @Test
    void shouldRetryOnSameAndNextServiceInstanceOnException() {
        Mockito.when((Object)this.clientRequest.method()).thenReturn((Object)HttpMethod.GET);
        Mockito.when((Object)this.next.exchange((ClientRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IllegalStateException(new IOException())});
        this.filterFunction.filter(this.clientRequest, this.next).subscribe();
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
    }

    @Test
    void shouldRetryOnSameAndNextServiceInstanceOnRetryableStatusCode() {
        Mockito.when((Object)this.clientRequest.method()).thenReturn((Object)HttpMethod.GET);
        Mockito.when((Object)this.clientResponse.statusCode()).thenReturn((Object)HttpStatus.NOT_FOUND);
        Mockito.when((Object)this.next.exchange((ClientRequest)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)this.clientResponse));
        this.filterFunction.filter(this.clientRequest, this.next).subscribe();
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
    }

    @Test
    void shouldNotRetryWhenNoRetryableExceptionOrStatusCode() {
        Mockito.when((Object)this.clientRequest.method()).thenReturn((Object)HttpMethod.GET);
        Mockito.when((Object)this.clientResponse.statusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)this.next.exchange((ClientRequest)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)this.clientResponse));
        this.filterFunction.filter(this.clientRequest, this.next).subscribe();
        ((ExchangeFunction)Mockito.verify((Object)this.next, (VerificationMode)Mockito.times((int)1))).exchange((ClientRequest)ArgumentMatchers.any());
        ((ReactiveLoadBalancer.Factory)Mockito.verify(this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
    }

    @Test
    void shouldNotRetryOnMethodOtherThanGet() {
        Mockito.when((Object)this.clientRequest.method()).thenReturn((Object)HttpMethod.POST);
        Mockito.when((Object)this.clientResponse.statusCode()).thenReturn((Object)HttpStatus.NOT_FOUND);
        Mockito.when((Object)this.next.exchange((ClientRequest)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)this.clientResponse));
        this.filterFunction.filter(this.clientRequest, this.next).subscribe();
        ((ExchangeFunction)Mockito.verify((Object)this.next, (VerificationMode)Mockito.times((int)1))).exchange((ClientRequest)ArgumentMatchers.any());
        ((ReactiveLoadBalancer.Factory)Mockito.verify(this.factory, (VerificationMode)Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
    }

    @Test
    void shouldRetryOnMethodOtherThanGetWhenEnabled() {
        LoadBalancerProperties properties = new LoadBalancerProperties();
        properties.getRetry().setRetryOnAllOperations(true);
        properties.getRetry().setMaxRetriesOnSameServiceInstance(1);
        properties.getRetry().getRetryableStatusCodes().add(404);
        RetryableExchangeFilterFunctionLoadBalancerRetryPolicy policy = new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(properties);
        RetryableLoadBalancerExchangeFilterFunction filterFunction = new RetryableLoadBalancerExchangeFilterFunction((LoadBalancerRetryPolicy)policy, this.factory, properties);
        Mockito.when((Object)this.clientRequest.method()).thenReturn((Object)HttpMethod.POST);
        Mockito.when((Object)this.clientResponse.statusCode()).thenReturn((Object)HttpStatus.NOT_FOUND);
        Mockito.when((Object)this.next.exchange((ClientRequest)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)this.clientResponse));
        filterFunction.filter(this.clientRequest, this.next).subscribe();
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
        ((ReactiveLoadBalancer.Factory)this.inOrder.verify(this.factory, Mockito.times((int)1))).getInstance((String)ArgumentMatchers.any());
        ((ExchangeFunction)this.inOrder.verify((Object)this.next, Mockito.times((int)2))).exchange((ClientRequest)ArgumentMatchers.any());
    }
}

