/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.web.server.LocalManagementPort;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Config.class}, properties={"management.port=0"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class AbstractAutoServiceRegistrationTests {
    @Autowired
    public PostEventListener postEventListener;
    @Autowired
    private TestAutoServiceRegistration autoRegistration;
    @Autowired
    private PreEventListener preEventListener;
    @LocalServerPort
    private int port;
    @LocalManagementPort
    private int managementPort;

    @Test
    public void portsWork() {
        BDDAssertions.then((int)this.autoRegistration.getPort().get()).isNotEqualTo(0).as("Lifecycle port is zero", new Object[0]);
        BDDAssertions.then((int)this.managementPort).isNotEqualTo(this.autoRegistration.getPort().get()).as("Lifecycle port is management port", new Object[0]);
        BDDAssertions.then((int)this.port).isEqualTo(this.autoRegistration.getPort().get()).as("Lifecycle port is wrong", new Object[0]);
        BDDAssertions.then((boolean)this.autoRegistration.isRunning()).isTrue().as("Lifecycle not running", new Object[0]);
        ((ObjectAssert)BDDAssertions.then((Object)this.autoRegistration.getServiceRegistry()).isInstanceOf(TestServiceRegistry.class)).as("ServiceRegistry is wrong type", new Object[0]);
        TestServiceRegistry serviceRegistry = (TestServiceRegistry)this.autoRegistration.getServiceRegistry();
        BDDAssertions.then((boolean)serviceRegistry.isRegistered()).isTrue().as("Lifecycle not registered", new Object[0]);
        ((AbstractStringAssert)BDDAssertions.then((String)this.autoRegistration.getAppName()).as("Lifecycle appName is wrong", new Object[0])).isEqualTo("application");
    }

    @Test
    public void eventsFireTest() {
        BDDAssertions.then((boolean)this.preEventListener.wasFired).isTrue();
        BDDAssertions.then((String)this.preEventListener.registration.getServiceId()).isEqualTo("testRegistration2");
        BDDAssertions.then((boolean)this.postEventListener.wasFired).isTrue();
        BDDAssertions.then((String)this.postEventListener.config.getServiceId()).isEqualTo("testRegistration2");
    }

    public static class TestAutoServiceRegistration
    extends AbstractAutoServiceRegistration<TestRegistration> {
        private int port = 0;

        public TestAutoServiceRegistration(AutoServiceRegistrationProperties properties) {
            super(null, properties);
        }

        protected TestAutoServiceRegistration() {
            super((ServiceRegistry)new TestServiceRegistry());
        }

        protected AtomicInteger getPort() {
            return super.getPort();
        }

        protected String getAppName() {
            return super.getAppName();
        }

        protected int getConfiguredPort() {
            return this.port;
        }

        protected void setConfiguredPort(int port) {
            this.port = port;
        }

        protected TestRegistration getRegistration() {
            return new TestRegistration();
        }

        protected TestRegistration getManagementRegistration() {
            return null;
        }

        protected Object getConfiguration() {
            return this.getRegistration();
        }

        protected boolean isEnabled() {
            return true;
        }
    }

    public static class TestServiceRegistry
    implements ServiceRegistry<TestRegistration> {
        private boolean registered = false;
        private boolean deregistered = false;

        public void register(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.registered = true;
            }
        }

        public void deregister(TestRegistration registration) {
            if (registration == null) {
                throw new NullPointerException();
            }
            if (!(registration instanceof TestMgmtRegistration)) {
                this.deregistered = true;
            }
        }

        public void close() {
        }

        public void setStatus(TestRegistration registration, String status) {
        }

        public Object getStatus(TestRegistration registration) {
            return null;
        }

        boolean isRegistered() {
            return this.registered;
        }

        boolean isDeregistered() {
            return this.deregistered;
        }
    }

    public static class TestMgmtRegistration
    extends TestRegistration {
        @Override
        public String getServiceId() {
            return "testMgmtRegistration2";
        }
    }

    public static class TestRegistration
    implements Registration {
        public String getInstanceId() {
            return "testRegistrationInstance2";
        }

        public String getServiceId() {
            return "testRegistration2";
        }

        public String getHost() {
            return null;
        }

        public int getPort() {
            return 0;
        }

        public boolean isSecure() {
            return false;
        }

        public URI getUri() {
            return null;
        }

        public Map<String, String> getMetadata() {
            return null;
        }
    }

    public static class PostEventListener
    implements ApplicationListener<InstanceRegisteredEvent> {
        public boolean wasFired = false;
        public Registration config;

        public void onApplicationEvent(InstanceRegisteredEvent event) {
            this.config = (Registration)event.getConfig();
            this.wasFired = true;
        }
    }

    public static class PreEventListener
    implements ApplicationListener<InstancePreRegisteredEvent> {
        public boolean wasFired = false;
        public Registration registration;

        public void onApplicationEvent(InstancePreRegisteredEvent event) {
            this.registration = event.getRegistration();
            this.wasFired = true;
        }
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    public static class Config {
        @Bean
        public TestAutoServiceRegistration testAutoServiceRegistration() {
            return new TestAutoServiceRegistration();
        }

        @Bean
        public PreEventListener preRegisterListener() {
            return new PreEventListener();
        }

        @Bean
        public PostEventListener postEventListener() {
            return new PostEventListener();
        }
    }
}

