/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import okhttp3.OkHttpClient;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.commons.httpclient.CustomOkHttpClientBuilderApplication;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.ReflectionUtils;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CustomOkHttpClientBuilderApplication.class})
public class CustomOkHttpClientBuilderConfigurationTests {
    @Autowired
    private OkHttpClientFactory okHttpClientFactory;

    @Test
    public void testCustomBuilder() {
        OkHttpClient.Builder builder = this.okHttpClientFactory.createBuilder(false);
        Integer timeout = (Integer)this.getField(builder, "connectTimeout");
        BDDAssertions.then((int)timeout).isEqualTo(1);
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

