/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultApacheHttpClientFactoryTests {
    @Test
    public void createClient() throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(100).setConnectTimeout(200).setCookieSpec("ignoreCookies").build();
        CloseableHttpClient httpClient = new DefaultApacheHttpClientFactory(HttpClientBuilder.create()).createBuilder().setConnectionManager((HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class)).setDefaultRequestConfig(requestConfig).build();
        BDDAssertions.then((Object)httpClient).isInstanceOf(Configurable.class);
        RequestConfig config = ((Configurable)httpClient).getConfig();
        BDDAssertions.then((int)config.getSocketTimeout()).isEqualTo(100);
        BDDAssertions.then((int)config.getConnectTimeout()).isEqualTo(200);
        BDDAssertions.then((String)config.getCookieSpec()).isEqualTo("ignoreCookies");
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

