/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.internal.connection.RealConnectionPool;
import org.assertj.core.api.BDDAssertions;
import org.junit.Test;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultOkHttpClientConnectionPoolFactoryTest {
    @Test
    public void create() {
        DefaultOkHttpClientConnectionPoolFactory connectionPoolFactory = new DefaultOkHttpClientConnectionPoolFactory();
        ConnectionPool connectionPool = connectionPoolFactory.create(2, 3L, TimeUnit.MILLISECONDS);
        RealConnectionPool delegate = (RealConnectionPool)this.getField(connectionPool, "delegate");
        int idleConnections = (Integer)this.getField(delegate, "maxIdleConnections");
        long keepAliveDuration = (Long)this.getField(delegate, "keepAliveDurationNs");
        BDDAssertions.then((int)idleConnections).isEqualTo(2);
        BDDAssertions.then((long)keepAliveDuration).isEqualTo(TimeUnit.MILLISECONDS.toNanos(3L));
    }

    protected <T> T getField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalArgumentException("Can not find field " + name + " in " + target.getClass());
        }
        ReflectionUtils.makeAccessible((Field)field);
        Object value = ReflectionUtils.getField((Field)field, (Object)target);
        return (T)value;
    }
}

