/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.BDDAssertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.core.env.PropertyResolver;
import org.springframework.mock.env.MockEnvironment;

public class IdUtilsTests {
    public static final String DEFAULT_ID = "id1";
    private MockEnvironment env;

    @Before
    public void setup() {
        this.env = new MockEnvironment();
    }

    @After
    public void destroy() {
        this.env = null;
    }

    @Test
    public void emptyEnvironmentWorks() {
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        ((AbstractStringAssert)BDDAssertions.then((String)instanceId).as("instanceId was not null", new Object[0])).isNull();
    }

    @Test
    public void vcapInstanceIdWorks() {
        this.env.setProperty("vcap.application.instance_id", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void hostnameWorks() {
        this.env.setProperty("spring.cloud.client.hostname", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void appNameWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void hostnameAndAppNameWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("spring.cloud.client.hostname", "id12");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        ((AbstractStringAssert)BDDAssertions.then((String)instanceId).as("instanceId was wrong", new Object[0])).isEqualTo("id12:id1");
    }

    @Test
    public void instanceIdWorks() {
        this.env.setProperty("spring.cloud.client.hostname", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void portWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)DEFAULT_ID).isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void appNameAndPortWorks() {
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("server.port", "80");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)"id1:80").isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void fullWorks() {
        this.env.setProperty("spring.cloud.client.hostname", "myhost");
        this.env.setProperty("spring.application.name", DEFAULT_ID);
        this.env.setProperty("server.port", "80");
        String instanceId = IdUtils.getDefaultInstanceId((PropertyResolver)this.env);
        BDDAssertions.then((String)"myhost:id1:80").isEqualTo(instanceId).as("instanceId was wrong", new Object[0]);
    }

    @Test
    public void testUnresolvedServiceId() {
        BDDAssertions.then((String)"${vcap.application.name:${spring.application.name:application}}:${vcap.application.instance_index:${spring.application.index:${local.server.port:${server.port:0}}}}:${vcap.application.instance_id:${cachedrandom.${vcap.application.name:${spring.application.name:application}}.value}}").isEqualTo(IdUtils.getUnresolvedServiceId());
    }

    @Test
    public void testServiceIdDefaults() {
        this.env.setProperty("cachedrandom.application.value", "123abc");
        BDDAssertions.then((String)"application:0:123abc").isEqualTo(IdUtils.getResolvedServiceId((PropertyResolver)this.env));
    }

    @Test
    public void testVCAPServiceId() {
        this.env.setProperty("vcap.application.name", "vcapname");
        this.env.setProperty("vcap.application.instance_index", "vcapindex");
        this.env.setProperty("vcap.application.instance_id", "vcapid");
        BDDAssertions.then((String)"vcapname:vcapindex:vcapid").isEqualTo(IdUtils.getResolvedServiceId((PropertyResolver)this.env));
    }

    @Test
    public void testSpringServiceId() {
        this.env.setProperty("spring.application.name", "springname");
        this.env.setProperty("spring.application.index", "springindex");
        this.env.setProperty("cachedrandom.springname.value", "123abc");
        BDDAssertions.then((String)"springname:springindex:123abc").isEqualTo(IdUtils.getResolvedServiceId((PropertyResolver)this.env));
    }

    @Test
    public void testServerPortServiceId() {
        this.env.setProperty("spring.application.name", "springname");
        this.env.setProperty("server.port", "1234");
        this.env.setProperty("cachedrandom.springname.value", "123abc");
        BDDAssertions.then((String)"springname:1234:123abc").isEqualTo(IdUtils.getResolvedServiceId((PropertyResolver)this.env));
    }
}

